/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts.checkers;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.db.CheckType;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.server.alerts.CheckResult;
import com.dataiku.fm.server.alerts.CheckResultStatus;
import com.dataiku.fm.server.alerts.checkers.LogicalInstanceChecker;
import com.dataiku.fm.server.instances.InstancesHelper;
import java.util.Set;

public class LogicalInstanceInvalidStatusV1Checker
extends LogicalInstanceChecker {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.checker.logicalInstanceInvalidStatusV1");
    private static final Set<PhysicalInstance.LifecycleStage> INVALID_PHYSICAL_INSTANCE_STAGES = Set.of(PhysicalInstance.LifecycleStage.FAILED, PhysicalInstance.LifecycleStage.NOT_RESPONDING);
    private static final String CHECK_RESULT_STANDARD_MESSAGE = "Instance %s %s";

    @Override
    public CheckResult check(String configurationAsString, LogicalInstance logicalInstance) {
        String logicalInstanceLabel = logicalInstance.getLabel();
        if (logicalInstance.getCurrentPhysicalInstance() != null) {
            PhysicalInstance physicalInstance = logicalInstance.getCurrentPhysicalInstance();
            PhysicalInstance.LifecycleStage lifecycleStage = InstancesHelper.computeLifeCycleStage(physicalInstance);
            logger.debugV("Machine status found: %s", new Object[]{lifecycleStage.name()});
            boolean check = !INVALID_PHYSICAL_INSTANCE_STAGES.contains((Object)lifecycleStage);
            String statusMessage = check ? " is back to a valid status" : " has unexpected status " + String.valueOf((Object)lifecycleStage);
            String message = String.format(CHECK_RESULT_STANDARD_MESSAGE, logicalInstanceLabel, statusMessage);
            return new CheckResult(check ? CheckResultStatus.SUCCESS : CheckResultStatus.FAILURE, logicalInstanceLabel, message);
        }
        logger.errorV("Invalid status has been checked on logical instance %s that has no associated physical instance", new Object[]{logicalInstance.getId()});
        return new CheckResult(CheckResultStatus.INCONCLUSIVE, logicalInstanceLabel, String.format("Missing data from %s %s to compute %s", "instance", logicalInstanceLabel, "status"));
    }

    @Override
    public Class<?> getConfigurationClass() {
        return Configuration.class;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.LOGICAL_INSTANCE_INVALID_STATUS;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static class Configuration {
        private Configuration() {
        }
    }
}

