/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts.messagebuilders;

import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.db.MessagingChannelType;
import com.dataiku.fm.server.alerts.messagebuilders.SMTPMessageBuilder;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;

public class SMTPV1MessageBuilder
extends SMTPMessageBuilder {
    @Override
    public Class<?> getConfigurationClass() {
        return Configuration.class;
    }

    @Override
    public MessagingChannelType getMessagingChannelType() {
        return MessagingChannelType.SMTP;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Message enrichMessage(Message message, String checkReporterConfiguration) throws MessagingException {
        Configuration configuration = (Configuration)JSON.parse((String)checkReporterConfiguration, Configuration.class);
        if (StringUtils.isEmpty((String)configuration.sender)) {
            throw new MessagingException("The sender for the notification email should not be null");
        }
        InternetAddress sender = new InternetAddress(configuration.sender);
        message.setFrom((Address)sender);
        if (StringUtils.isEmpty((String)configuration.recipients)) {
            throw new MessagingException("The recipients for the notification email should not be null");
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)configuration.recipients));
        return message;
    }

    private static class Configuration {
        @Nullable
        private String sender;
        @Nullable
        private String recipients;

        private Configuration() {
        }
    }
}

