/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JF;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.model.published.FMUserNoLeakDTO;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.FMTenancy;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.security.FMUIAuthService;
import com.dataiku.fm.server.security.FMUsersServiceFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class FMAppConfigController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMUsersServiceFactory fmUsersServiceFactory;
    @Autowired
    private LicenseStatusService licenseStatusService;

    private FMAppConfig getConfigurationInternal(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAppConfig c = new FMAppConfig();
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        c.version = FMApp.getDSSVersion();
        if (System.getenv("DKUDISTRIB") != null) {
            String str = System.getenv("DKUDISTRIB");
            c.distrib = StringUtils.split((String)str, (char)' ')[0];
            c.distribVersion = str.substring(c.distrib.length() + 1);
        } else {
            c.distrib = "unknown";
            c.distribVersion = "unknown";
        }
        c.nodeType = DKUApp.getInstallNodeType();
        c.dipInstanceId = DKUApp.dipInstanceId();
        c.installId = DKUApp.getInstallId();
        c.udr = true;
        c.pingTracking = DKUApp.getParams().getBoolParam("dku.tracking.pingTracking", true);
        c.pingTrackingInterval = DKUApp.getParams().getIntParam("dku.tracking.pingTrackingInterval", Integer.valueOf(120000));
        c.debug = DKUApp.debugEnabled();
        c.devInstance = System.getenv("DSS_DEV") != null;
        c.xsrfCookieName = FMUIAuthService.getXSRFCookieName();
        c.nodeName = null;
        c.dssExternalURL = "TODO";
        c.tenancy = fmSettings.tenancy;
        c.ssoLoginEnabled = fmSettings.ssoSettings.enabled;
        c.ssoProtocol = fmSettings.ssoSettings.protocol;
        c.featureFlags = FeatureFlags.listEnabled();
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getUserNoXSRF(req);
        if (authCtx != null) {
            if (authCtx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
                throw new DKUSecurityException("Unexpected auth source: " + String.valueOf(authCtx.getAuthSource()));
            }
            FMUser fmUser = this.fmUsersServiceFactory.get(authCtx.getTenantId()).getUserOrNull(authCtx.getIdentifier());
            c.loggedIn = true;
            c.login = fmUser.getEmailAddress();
            c.user = new FMUserNoLeakDTO(fmUser);
            this.uiAuthService.setXSRFCookie(req, resp);
            c.tenantHasLicense = StringUtils.isNotBlank((String)fmUser.getTenant().getLicense());
        }
        if (c.loggedIn) {
            c.cloud = fmSettings.cloud;
        }
        if (c.loggedIn) {
            // empty if block
        }
        if (!c.loggedIn) {
            c.distrib = null;
            c.distribVersion = null;
            c.version = null;
        }
        return c;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/ping"})
    public void ping(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        FMAppConfigController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().with("pong", Boolean.valueOf(true)).get());
    }

    @AuditedCall(value={"msgType", "application-open"})
    @RequestMapping(value={"/api/ui/get-configuration"})
    public void getConfiguration(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAppConfig appConfig = this.getConfigurationInternal(req, resp);
        FMAppConfigController.writeJSON((HttpServletResponse)resp, (Object)appConfig);
    }

    public static class FMAppConfig {
        String nodeType;
        String dipInstanceId;
        String installId;
        DKUApp.DSSVersion version;
        boolean ssoLoginEnabled;
        SSOSettings.SSOProtocol ssoProtocol;
        boolean loggedIn;
        String login;
        FMUserNoLeakDTO user;
        boolean debug;
        boolean devInstance;
        boolean udr;
        boolean pingTracking;
        int pingTrackingInterval;
        boolean admin;
        String xsrfCookieName;
        String nodeId;
        String distrib;
        String distribVersion;
        String dssExternalURL;
        String nodeName;
        boolean tenantHasLicense;
        FMTenancy tenancy;
        Cloud cloud;
        List<String> featureFlags;
    }
}

