/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.InstanceSettingsTemplateDTO;
import com.dataiku.fm.model.published.UpdateInstanceSettingsTemplateResult;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class InstanceSettingsTemplatesController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private InstanceSettingsTemplateCRUDService instancesettingstemplateService;

    @RequestMapping(value={"/api/ui/instance-settings-templates/list"})
    public void listInstanceSettingsTemplatesInstances(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, this.instancesettingstemplateService.list(authCtx.getTenantId()));
    }

    @RequestMapping(value={"/api/ui/instance-settings-templates/create"})
    public void createInstanceSettingsTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instancesettingstemplate) throws Exception {
        InstanceSettingsTemplateDTO dto = (InstanceSettingsTemplateDTO)JSON.parse((String)instancesettingstemplate, InstanceSettingsTemplateDTO.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        InstanceSettingsTemplateDTO instanceSettingsTemplateDTO = this.instancesettingstemplateService.create(authCtx, authCtx.getTenantId(), dto);
        this.instancesettingstemplateService.decryptSecrets(instanceSettingsTemplateDTO, tenant);
        InstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, (Object)instanceSettingsTemplateDTO);
    }

    @RequestMapping(value={"/api/ui/instance-settings-templates/get"})
    public void getInstanceSettingsTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instancesettingstemplateId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        InstanceSettingsTemplateDTO instanceSettingsTemplate = this.instancesettingstemplateService.get(authCtx.getTenantId(), instancesettingstemplateId);
        this.instancesettingstemplateService.decryptSecrets(instanceSettingsTemplate, tenant);
        InstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, (Object)instanceSettingsTemplate);
    }

    @RequestMapping(value={"/api/ui/instance-settings-templates/save"})
    public void saveInstanceSettingsTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instancesettingstemplate) throws Exception {
        InstanceSettingsTemplateDTO dto = (InstanceSettingsTemplateDTO)JSON.parse((String)instancesettingstemplate, InstanceSettingsTemplateDTO.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            UpdateInstanceSettingsTemplateResult update = this.instancesettingstemplateService.update(authCtx, authCtx.getTenantId(), dto);
            this.instancesettingstemplateService.decryptSecrets(update.ist, tenant);
            InstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, (Object)update);
            rwt.commit();
        }
    }

    @RequestMapping(value={"/api/ui/instance-settings-templates/delete"})
    public void deleteInstanceSettingsTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instancesettingstemplateId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, (Object)this.instancesettingstemplateService.delete(authCtx.getTenantId(), instancesettingstemplateId));
    }
}

