/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.fm.model.published.PublicLogicalInstance;
import com.dataiku.fm.model.published.PublicProtoLogicalInstance;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesController;
import com.dataiku.fm.server.instances.PhysicalInstanceCommandService;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPIInstancesController
extends PublicAPIControllerBase {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private InstancesCRUDService instancesCRUDService;
    @Autowired
    private PhysicalInstanceProvisioningService reprovisionService;
    @Autowired
    private PhysicalInstanceCommandService commandService;
    @Autowired
    private InstanceService instanceService;

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances"}, method={RequestMethod.GET})
    public void listTenantInstances(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        List<PublicLogicalInstance> ret = this.instanceService.list(tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, ret);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/images"}, method={RequestMethod.GET})
    public void listInstanceImages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        List dssImages = FMApp.getInstanceImagesSettings((Cloud)settings.cloud).images.stream().map(ii -> new InstancesController.IdAndLabel(ii.id, ii.label)).collect(Collectors.toList());
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, dssImages);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances"}, method={RequestMethod.POST})
    public void createInstance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicProtoLogicalInstance ppli = (PublicProtoLogicalInstance)this.getRequestBodyAs(req, PublicProtoLogicalInstance.class);
        this.checkNotBlank(ppli.label, "Instance label is null", new Object[0]);
        this.checkNotBlank(ppli.virtualNetworkId, "Instance virtual network id is null", new Object[0]);
        this.checkNotBlank(ppli.instanceSettingsTemplateId, "Instance settings template id is null", new Object[0]);
        PublicLogicalInstance pli = this.instanceService.create(tenantId, ppli);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, (Object)pli);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}"}, method={RequestMethod.GET})
    public void getLogicalInstance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, (Object)this.instanceService.get(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}"}, method={RequestMethod.PUT})
    public void updateLogicalInstance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicLogicalInstance pli = (PublicLogicalInstance)this.getRequestBodyAs(req, PublicLogicalInstance.class);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.instanceService.update(tenantId, pli);
            rwt.commit();
        }
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/status"}, method={RequestMethod.GET})
    public void getInstanceStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, (Object)this.reprovisionService.getStatus(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/reprovision"})
    public void startReprovision(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startReprovision(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/deprovision"})
    public void startDeprovision(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startDeprovision(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/restart-dss"})
    public void startRestartDSS(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startDSSRestart(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/delete"})
    public void startDelete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startDeleteInstance(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/start"})
    public void startInstance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startPhysicalStart(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/stop"})
    public void stopInstance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startPhysicalStop(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/get-initial-password"})
    public void getInitialPassword(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, (Object)this.instanceService.getInitialAdminPassword(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/admin-api-key"})
    public void getAdminAPIKey(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, (Object)this.instancesCRUDService.getAdminAPIKey(tenantId, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/replay-setup-actions"})
    public void replaySetupActions(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.commandService.replaySetupActions(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/reset-user-password"}, method={RequestMethod.GET})
    public void resetUserPassword(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId, @RequestParam String userName, @RequestParam String password) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.commandService.resetUserPassword(authCtx, instanceId, userName, password));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/actions/reset-user-password"}, method={RequestMethod.POST})
    public void resetUserPasswordPOST(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        ResetPasswordRequest resetRequest = (ResetPasswordRequest)this.getRequestBodyAs(req, ResetPasswordRequest.class);
        PublicAPIInstancesController.writeJSON((HttpServletResponse)resp, this.commandService.resetUserPassword(authCtx, instanceId, resetRequest.userName, resetRequest.password));
    }

    public static class ResetPasswordRequest {
        public String userName;
        public String password;
    }
}

