/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.util.HTTPClientBaseUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.server.db.DatabaseAccessService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMAgentAuthService {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudCryptoService cryptoService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.auth");

    public LogicalInstance verifyAgentAuth(String tenantId, String instanceId, HttpServletRequest req) throws IOException, DKUSecurityException {
        String token = HTTPClientBaseUtils.decodeBearerAuth((HttpServletRequest)req);
        if (token == null || StringUtils.isBlank((String)token)) {
            logger.warn((Object)"Could not authenticate agent query: no Bearer token received");
            throw new DKUSecurityException("Unauthenticated call");
        }
        LogicalInstance li = this.dbService.getSingleResult(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant.id = ?1 AND li.id = ?2", tenantId, instanceId);
        if (li == null) {
            logger.warnV("Could not find instance for tenant=%s instance=%s", new Object[]{tenantId, instanceId});
            throw new DKUSecurityException("Bad authentication");
        }
        if (!token.equals(li.getPossiblyEncryptedAgentSecret()) && !token.equals(this.cryptoService.decrypt(li.getTenant(), li.getPossiblyEncryptedAgentSecret()))) {
            logger.warnV("Invalid agent secret for tenant=%s instance=%s", new Object[]{tenantId, instanceId});
            throw new DKUSecurityException("Bad authentication");
        }
        return li;
    }
}

