/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.published.FMUserDTO;
import com.dataiku.fm.model.published.FMUserNoLeakDTO;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import com.dataiku.fm.server.security.FMUsersServiceFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class FMUsersController
extends DIPInternalControllerBase {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private FMUsersServiceFactory fmUsersServiceFactory;

    @RequestMapping(value={"/api/ui/users/list"})
    public void listUsers(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        List<FMUserNoLeakDTO> fmUserNoLeakDTOs = this.fmUsersServiceFactory.get(authCtx.getTenantId()).list();
        FMUsersController.writeJSON((HttpServletResponse)resp, fmUserNoLeakDTOs);
    }

    @RequestMapping(value={"/api/ui/users/create"})
    public void createUser(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws Exception {
        FMUserDTO fmUserDTO = (FMUserDTO)JSON.parse((String)user, FMUserDTO.class);
        if (StringUtils.isBlank((String)fmUserDTO.emailAddress)) {
            throw new IllegalArgumentException("Email address is required to create a new user");
        }
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        FMUserNoLeakDTO createdFMUserNoLeakDTO = this.fmUsersServiceFactory.get(authCtx.getTenantId()).create(fmUserDTO);
        FMUsersController.writeJSON((HttpServletResponse)resp, (Object)createdFMUserNoLeakDTO);
    }

    @RequestMapping(value={"/api/ui/users/get"})
    public void getUser(HttpServletRequest req, HttpServletResponse resp, @RequestParam String emailAddress) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        FMUsersController.writeJSON((HttpServletResponse)resp, (Object)this.fmUsersServiceFactory.get(authCtx.getTenantId()).getUserNoLeakDTO(emailAddress));
    }

    @RequestMapping(value={"/api/ui/users/save"})
    public void saveUser(HttpServletRequest req, HttpServletResponse resp, @RequestParam String emailAddress, @RequestParam String user) throws Exception {
        if (StringUtils.isBlank((String)emailAddress)) {
            throw new IllegalArgumentException("Invalid user");
        }
        FMUserDTO fmUserDTO = (FMUserDTO)JSON.parse((String)user, FMUserDTO.class);
        if (StringUtils.isBlank((String)fmUserDTO.emailAddress)) {
            throw new IllegalArgumentException("Email address if a required user field");
        }
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.fmUsersServiceFactory.get(authCtx.getTenantId()).updateUser(emailAddress, fmUserDTO);
            rwt.commit();
        }
        FMUsersController.writeJSON((HttpServletResponse)resp, (Object)this.fmUsersServiceFactory.get(authCtx.getTenantId()).getUserNoLeakDTO(fmUserDTO.emailAddress));
    }

    @RequestMapping(value={"/api/ui/users/delete"})
    public void deleteUser(HttpServletRequest req, HttpServletResponse resp, @RequestParam String emailAddress) throws Exception {
        if (StringUtils.isBlank((String)emailAddress)) {
            throw new IllegalArgumentException("Invalid user");
        }
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        if (emailAddress.equals(authCtx.getIdentifier())) {
            throw new IllegalArgumentException("Cannot delete yourself");
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.fmUsersServiceFactory.get(authCtx.getTenantId()).delete(emailAddress);
            rwt.commit();
        }
    }
}

