/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.tag;

import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.published.CloudTag;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.loadbalancers.LoadBalancersCRUDService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@ParametersAreNonnullByDefault
public class TagService {
    private static final String LOAD_BALANCER_ID_DEFAULT_KEY = "fm:loadBalancerId";
    private static final String LOAD_BALANCER_ID_SANITIZED_KEY = "fm.loadBalancerId";
    private static final String PHYSICAL_INSTANCE_ID_DEFAULT_KEY = "fm:physicalInstanceId";
    private static final String PHYSICAL_INSTANCE_ID_SANITIZED_KEY = "fm.physicalInstanceId";
    private static final String LOGICAL_INSTANCE_ID_DEFAULT_KEY = "fm:logicalInstanceId";
    private static final String LOGICAL_INSTANCE_ID_SANITIZED_KEY = "fm.logicalInstanceId";
    private final LoadBalancersCRUDService loadBalancersCRUDService;
    private final FMApp fmApp;
    private final String loadBalancerIdKey;
    private final String physicalInstanceKey;
    private final String logicalInstanceIdKey;

    @Autowired
    public TagService(LoadBalancersCRUDService loadBalancersCRUDService, FMApp fmApp, boolean useSanitizedKeys) {
        this.loadBalancersCRUDService = loadBalancersCRUDService;
        this.fmApp = fmApp;
        this.loadBalancerIdKey = useSanitizedKeys ? LOAD_BALANCER_ID_SANITIZED_KEY : LOAD_BALANCER_ID_DEFAULT_KEY;
        this.physicalInstanceKey = useSanitizedKeys ? PHYSICAL_INSTANCE_ID_SANITIZED_KEY : PHYSICAL_INSTANCE_ID_DEFAULT_KEY;
        this.logicalInstanceIdKey = useSanitizedKeys ? LOGICAL_INSTANCE_ID_SANITIZED_KEY : LOGICAL_INSTANCE_ID_DEFAULT_KEY;
    }

    public Optional<String> getLoadBalancerId(Map<String, String> tags) {
        return Optional.ofNullable(tags.get(this.loadBalancerIdKey));
    }

    public CloudTagList getCloudApplicableTags(LogicalLoadBalancer logicalLoadBalancer) {
        return logicalLoadBalancer.getVirtualNetwork().getCloudApplicableTags(this.fmApp.getFMSettings()).with(CloudTagList.fromJSON(logicalLoadBalancer.getCloudTags())).with(this.loadBalancerIdKey, logicalLoadBalancer.getId());
    }

    public CloudTagList getCloudApplicableTags(LogicalInstance logicalInstance) {
        CloudTagList tagsList = this.loadBalancersCRUDService.getLoadBalancer(logicalInstance.getId()).map(this::getCloudApplicableTags).orElseGet(() -> logicalInstance.getVirtualNetwork().getCloudApplicableTags(this.fmApp.getFMSettings()));
        tagsList = tagsList.with(CloudTagList.fromJSON(logicalInstance.getCloudTags()));
        if (logicalInstance.getCurrentPhysicalInstance() != null) {
            tagsList = tagsList.with(this.physicalInstanceKey, logicalInstance.getCurrentPhysicalInstance().getId());
        }
        return tagsList.with(this.logicalInstanceIdKey, logicalInstance.getId());
    }

    public CloudTagList getCloudApplicableTags(LogicalInstance logicalInstance, String physicalInstanceId) {
        return this.getCloudApplicableTags(logicalInstance, Optional.of(physicalInstanceId), Optional.empty());
    }

    public CloudTagList getCloudApplicableTags(LogicalInstance logicalInstance, String physicalInstanceId, String restoredFromFMSnapshotId) {
        return this.getCloudApplicableTags(logicalInstance, Optional.of(physicalInstanceId), Optional.of(restoredFromFMSnapshotId));
    }

    public CloudTagList getCloudApplicableTags(LogicalInstance logicalInstance, Optional<String> physicalInstanceIdOptional, Optional<String> restoredFromFMSnapshotIdOptional) {
        Stream extraCloudTagStream = Stream.of(physicalInstanceIdOptional.map(physicalInstanceId -> new CloudTag(PHYSICAL_INSTANCE_ID_DEFAULT_KEY, (String)physicalInstanceId)).stream(), restoredFromFMSnapshotIdOptional.map(snapshotId -> new CloudTag("fm:restoredFromFMSnapshotId", (String)snapshotId)).stream()).flatMap(Function.identity());
        return this.getCloudApplicableTags(logicalInstance).with(extraCloudTagStream.toList());
    }

    public CloudTagList getSnapshotCloudApplicableTags(LogicalInstance logicalInstance, String type, String reason, Optional<String> nameKeyOptional) {
        return this.getSnapshotCloudApplicableTags(this.getCloudApplicableTags(logicalInstance), type, reason, logicalInstance.getLabel(), nameKeyOptional);
    }

    public CloudTagList getSnapshotCloudApplicableTags(LogicalInstance logicalInstance, String physicalInstanceId, String type, String reason, Optional<String> nameKeyOptional) {
        return this.getSnapshotCloudApplicableTags(this.getCloudApplicableTags(logicalInstance, Optional.of(physicalInstanceId), Optional.empty()), type, reason, logicalInstance.getLabel(), nameKeyOptional);
    }

    private CloudTagList getSnapshotCloudApplicableTags(CloudTagList instanceCloudTagList, String type, String reason, String logicalInstanceLabel, Optional<String> nameKeyOptional) {
        List<CloudTag> snapshotSpecificTags = Stream.concat(Stream.of(new CloudTag("fm:snapshotType", type), new CloudTag("fm:reasonForSnapshot", reason)), nameKeyOptional.map(nameKey -> new CloudTag((String)nameKey, "Snapshot of " + logicalInstanceLabel + " (DSS managed by FM)")).stream()).toList();
        return instanceCloudTagList.with(snapshotSpecificTags);
    }

    @Configuration
    public static class BeanFactory {
        @Autowired
        private LoadBalancersCRUDService loadBalancersCRUDService;
        @Autowired
        FMApp fmApp;

        @Primary
        @Bean(value={"defaultKeys"})
        public TagService getDefaultKeysTagService() {
            return new TagService(this.loadBalancersCRUDService, this.fmApp, false);
        }

        @Bean(value={"sanitizedKeys"})
        public TagService getSanitizedKeyTagService() {
            return new TagService(this.loadBalancersCRUDService, this.fmApp, true);
        }
    }
}

