/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.simulator;

import com.dataiku.fm.simulator.SimulatedCrashException;
import com.dataiku.fm.simulator.SimulatedFailureException;
import com.dataiku.fm.simulator.SimulatorVariables;

public class SimulatorBasics {
    private final SimulatorVariables variables;

    public SimulatorBasics(SimulatorVariables variables) {
        this.variables = variables;
    }

    public void simulate(String step) {
        this.sleep(step);
        this.failIf(step);
    }

    public void simulateInterruptable(String step) throws InterruptedException {
        this.sleepInterruptable(step);
        this.crashIf(step);
        this.failIf(step);
    }

    public void sleep(String durationVariable) {
        try {
            this.sleepInterruptable(durationVariable);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void sleepInterruptable(String durationVariable) throws InterruptedException {
        long duration = this.variables.getDurationVariable(durationVariable);
        if (duration > 0L) {
            Thread.sleep(duration);
        }
    }

    public void failIf(String failureVariableName) {
        int failCount = this.variables.getFailVariableAndDecrement(failureVariableName);
        if (failCount > 0) {
            throw new SimulatedFailureException("Requested failure: " + failureVariableName + ". " + this.getInfoMessage("fail", failCount));
        }
    }

    public void crashIf(String failureVariableName) {
        int crashCount = this.variables.getCrashVariableAndDecrement(failureVariableName);
        if (crashCount > 0) {
            throw new SimulatedCrashException("Requested failure: " + failureVariableName + ". " + this.getInfoMessage("crash", crashCount));
        }
    }

    private String getInfoMessage(String operation, int failCount) {
        Object infoMsg = failCount == 1 ? "Next calls will succeed." : (failCount == 2 ? "The next call will " + operation + ", then subsequent calls will succeed." : (failCount == Integer.MAX_VALUE ? "All calls are doomed to " + operation + "." : "The following next " + (failCount - 1) + " calls will " + operation + ", then subsequent calls will succeed"));
        return infoMsg;
    }
}

