/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.simulator;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.InstanceService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.dataiku.fm.simulator.SimulatedCrashException;
import com.dataiku.fm.simulator.SimulatedFailureException;
import com.dataiku.fm.simulator.SimulatorBasics;
import com.dataiku.fm.simulator.SimulatorUtils;
import com.dataiku.fm.simulator.SimulatorVariables;
import com.dataiku.fm.simulator.model.CloudDisk;
import com.dataiku.fm.simulator.model.CloudVM;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.RandomStringUtils;

public class VMSimulator
extends Thread {
    private final InstanceAgentActionsQueueService queueService;
    private final PhysicalInstanceProvisioningService provisioningService;
    private final InstancesCRUDService instancesCRUDService;
    private final DatabaseAccessService dbService;
    private final InstanceService instanceService;
    private final String tenantId;
    private final String instanceId;
    private final StringBuilder logs = new StringBuilder();
    private final CloudVM vm;
    private final CloudDisk disk;
    private final SimulatorVariables variables;
    public volatile boolean stopRequested;
    public volatile boolean heartbeatActive = true;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.simulator.vm");

    public VMSimulator(String tenantId, String instanceId, CloudVM cloudVM, CloudDisk disk, SimulatorVariables variables) {
        this.vm = cloudVM;
        this.variables = variables;
        this.queueService = (InstanceAgentActionsQueueService)SpringUtils.getBean(InstanceAgentActionsQueueService.class);
        this.provisioningService = (PhysicalInstanceProvisioningService)SpringUtils.getBean(PhysicalInstanceProvisioningService.class);
        this.instancesCRUDService = (InstancesCRUDService)SpringUtils.getBean(InstancesCRUDService.class);
        this.dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        this.instanceService = (InstanceService)SpringUtils.getBean(InstanceService.class);
        this.tenantId = tenantId;
        this.instanceId = instanceId;
        this.disk = disk;
    }

    @Override
    public void run() {
        boolean autoRestartAgent;
        do {
            try {
                autoRestartAgent = false;
                this.runAgent();
            }
            catch (SimulatedCrashException e) {
                this.logAgent("Crashed... will auto restart.");
                autoRestartAgent = true;
                this.wait("agent.auto-restart");
            }
        } while (autoRestartAgent && !this.stopRequested && !VMSimulator.currentThread().isInterrupted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAgent() throws SimulatedCrashException {
        this.logAgent("Starting Agent");
        InstanceHeartbeatEmulatorThread heartbeatThread = new InstanceHeartbeatEmulatorThread();
        try {
            if (!this.stopRequested) {
                this.simulate("agent.bootstrap");
                this.runInThread("Instance state => Agent alive", new Runnable(){

                    @Override
                    public void run() {
                        VMSimulator.this.provisioningService.onAgentAlive(VMSimulator.this.tenantId, VMSimulator.this.instanceId);
                    }
                });
                heartbeatThread.start();
            }
            if (!this.stopRequested) {
                this.simulate("agent.initialize");
                if (!this.vm.dssInstalled) {
                    this.vm.dssInstalled = true;
                    this.runInThread("Install DSS", new Runnable(){

                        @Override
                        public void run() {
                            AgentAPIController.InstanceSecrets secrets = new AgentAPIController.InstanceSecrets();
                            secrets.adminPassword = VMSimulator.generateRandomPassword();
                            VMSimulator.this.instanceService.registerInstanceSecrets(VMSimulator.this.tenantId, VMSimulator.this.instanceId, secrets);
                        }
                    });
                }
                this.runInThread("Instance state => Initialization complete", new Runnable(){

                    @Override
                    public void run() {
                        VMSimulator.this.provisioningService.onInitializationComplete(VMSimulator.this.tenantId, VMSimulator.this.instanceId);
                    }
                });
            }
            if (!this.stopRequested) {
                try {
                    this.simulate("agent.start-dss");
                    this.runInThread("Instance state => Startup complete", new Runnable(){

                        @Override
                        public void run() {
                            VMSimulator.this.provisioningService.onStartupComplete(VMSimulator.this.tenantId, VMSimulator.this.instanceId);
                        }
                    });
                }
                catch (SimulatedFailureException e) {
                    final SerializedError se = new SerializedError((Throwable)e, false);
                    this.runInThread("Instance state => Startup failed", new Runnable(){

                        @Override
                        public void run() {
                            VMSimulator.this.provisioningService.onStartupFailed(VMSimulator.this.tenantId, VMSimulator.this.instanceId, se);
                        }
                    });
                }
            }
            this.logAgent("Agent started");
            while (!this.stopRequested && !VMSimulator.currentThread().isInterrupted()) {
                final InstanceAgentActionsQueueService.AgentCommand command = this.queueService.waitForCommand(this.tenantId, this.instanceId);
                if (command.type == InstanceAgentActionsQueueService.AgentCommandType.NO_OP) continue;
                final AgentAPIController.CommandResult commandResult = new AgentAPIController.CommandResult();
                this.logAgent("Received command " + JSON.pretty((Object)command));
                try {
                    this.executeCommand(command);
                    commandResult.outcome = InstanceAgentActionsQueueService.CommandState.DONE;
                }
                catch (SimulatedFailureException e) {
                    commandResult.outcome = InstanceAgentActionsQueueService.CommandState.FAILED;
                    commandResult.error = new SerializedError((Throwable)e, true);
                }
                this.runInThread("Acknowledge completion of command " + command.commandId, new Runnable(){

                    @Override
                    public void run() {
                        VMSimulator.this.queueService.acknowledgeCommandCompletion(VMSimulator.this.tenantId, VMSimulator.this.instanceId, command.commandId, commandResult);
                    }
                });
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Interrupting instance emulator due to InterruptedException", (Throwable)e);
        }
        finally {
            heartbeatThread.interrupt();
        }
    }

    public void setHeartbeatActive(boolean value) {
        this.heartbeatActive = value;
    }

    private void executeCommand(InstanceAgentActionsQueueService.AgentCommand command) throws InterruptedException {
        switch (command.type) {
            case RESTART_DSS: {
                this.logAgent("Restarting DSS");
                this.simulate("agent-command.restart-dss");
                break;
            }
            case RESET_USER_PASSWORD: {
                this.logAgent("Resetting user password");
                this.simulate("agent-command.reset-user-password");
                break;
            }
            case SEND_LOGS: {
                this.simulate("agent-command.send-logs");
                this.runInThread("Sending logs", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VMSimulator.this.instancesCRUDService.saveAgentLogs(VMSimulator.this.tenantId, VMSimulator.this.instanceId, new ByteArrayInputStream(VMSimulator.this.logs.toString().getBytes(StandardCharsets.UTF_8)));
                        }
                        catch (IOException e) {
                            logger.warn((Object)"Error occurred while saving agent logs", (Throwable)e);
                        }
                    }
                });
                break;
            }
            case GROW_FILESYSTEM: {
                this.simulate("agent-command.grow-filesystem");
                break;
            }
        }
    }

    private synchronized void logAgent(String msg) {
        String logLine = DKUDateUtils.isoFormatUTCNow() + " - " + msg + "\n";
        this.logs.append(logLine);
        logger.info((Object)("Simulator agent - " + msg));
    }

    private void simulate(String step) throws InterruptedException {
        new SimulatorBasics(this.variables).simulateInterruptable(step);
    }

    private void wait(String step) {
        new SimulatorBasics(this.variables).sleep(step);
    }

    private void runInThread(String message, Runnable runnable) throws InterruptedException {
        this.logAgent(message);
        SimulatorUtils.runInThread(runnable, this.dbService);
    }

    private static String generateRandomPassword() {
        return RandomStringUtils.randomAlphanumeric((int)10).toUpperCase();
    }

    private class InstanceHeartbeatEmulatorThread
    extends Thread {
        private InstanceHeartbeatEmulatorThread() {
        }

        @Override
        public void run() {
            try {
                while (!VMSimulator.this.stopRequested && !InstanceHeartbeatEmulatorThread.currentThread().isInterrupted()) {
                    if (VMSimulator.this.heartbeatActive) {
                        final long diskSizeGB = VMSimulator.this.disk.sizeGB;
                        final long diskUsedGB = VMSimulator.this.disk.usedGB;
                        VMSimulator.this.runInThread("Sending heartbeat", new Runnable(){

                            @Override
                            public void run() {
                                AgentAPIController.HeartbeatState heartbeatState = new AgentAPIController.HeartbeatState();
                                heartbeatState.state = AgentAPIController.HeartbeatHealthState.HEALTHY;
                                heartbeatState.bytesUsed = diskUsedGB * 0x40000000L;
                                heartbeatState.bytesTotal = diskSizeGB * 0x40000000L;
                                heartbeatState.deviceSize = diskSizeGB * 0x40000000L;
                                VMSimulator.this.instanceService.onHeartbeatReceived(VMSimulator.this.tenantId, VMSimulator.this.instanceId, heartbeatState);
                            }
                        });
                    }
                    InstanceHeartbeatEmulatorThread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Stopping instance heartbeat emulator", (Throwable)e);
            }
        }
    }
}

