(function() {
    'use strict';

    const app = angular.module('dataiku.services');

    app.service('TaggingService', function() {
        const COLORS = [
            "#1ac2ab",
            "#0f6d82",
            "#e6b800",
            "#de1ea5",
            "#90a8b7",
            "#28aadd",
            "#00a55a",
            "#ff9900",
            "#d66b9b",
            "#cc0000",
            "#123883",
            "#a088bd"
        ];

        this.fetchGlobalTags = function() {};

        this.getGlobalTagCategory = function() {
            return null;
        };

        this.getGlobalTags = function() {
            return [];
        };

        this.getTagColor = function(tag) {
            return this.getDefaultColor(tag);
        }

        this.getDefaultColor = function(tag) {
            const hash = angular.toJson(tag).split('').reduce(function(a, b) {
                a = ((a << 5) - a) + b.charCodeAt(0);
                return a & a; //NOSONAR a&a basically means floor, who cares if it is unclear here?
            }, 0);
            return COLORS[Math.abs(hash) % COLORS.length];
        }
    });
})();