(function() {
    'use strict';

    const app = angular.module("dataiku.fm.tenant", ["dataiku.services", "dataiku.filters", "dataiku.fm.dialogs", "dataiku.fm.base"]);

    app.controller("TenantViewController", function ($scope, $state, $location, FMAPI, ActivityIndicator, LicenseParser, TaggingService) {
        $scope.activeProjectTagColor = TaggingService.getDefaultColor;

        function get() {
            FMAPI.tenant.getCloudCredentials().success(function(data) {
                $scope.cloudCredentials = data;
                $scope.parsedLicense = LicenseParser.parseLicense($scope.cloudCredentials.license);
            }).error(setErrorInScope.bind($scope));

            FMAPI.tenant.getProxySettings().success(function(data) {
                $scope.proxySettings = data;
                if(($scope.proxySettings.password || "").length > 0){
                    $scope.proxySettings.password = "*".repeat($scope.proxySettings.password.length);
                }
            }).error(setErrorInScope.bind($scope));
        }

        get();

        $scope.getAuthenticateModeLabel = function() {
            switch ($scope.cloudCredentials.awsAuthenticationMode) {
                case 'DEFAULT_INSTANCE_CREDENTIALS':
                    return 'Same as Fleet Manager';
                case 'IAM_ROLE':
                    return 'IAM Role';
                case 'KEYPAIR':
                    return 'Keypair';
                default:
                    return 'Unknown';
            }
        };

        $scope.refreshLicense = function(){
            FMAPI.tenant.refreshLicense().success(function() {
                ActivityIndicator.success("License refreshed");
                get();
            }).error(setErrorInScope.bind($scope));
        }


        FMAPI.tenant.getCloudTags().success(function(data) {
            $scope.cloudTags = data;
        }).error(setErrorInScope.bind($scope));


    });

    app.controller("TenantEditController", function($rootScope, $scope, $state, $q, FMAPI, Dialogs, LicenseParser, WT1) {
        $scope.cloudSetupForm = {};
        function get() {
            FMAPI.accounts.getCreationData().success(function(data) {
                $scope.creationData = data;
            });

            FMAPI.tenant.getCloudCredentials().success(function(data) {
                $scope.cloudCredentials = data;
                $scope.parsedLicense = LicenseParser.parseLicense($scope.cloudCredentials.license);
            }).error(setErrorInScope.bind($scope));

            FMAPI.tenant.getProxySettings().success(function(data) {
                $scope.proxySettings = data;
            }).error(setErrorInScope.bind($scope));
        }

        get();

        FMAPI.tenant.getCloudTags().success(function(data) {
            $scope.cloudTags = data;
        }).error(setErrorInScope.bind($scope));

        $scope.openLicenseEditor = function() {
            $scope.showLicenseEditor = true;
        };
        $scope.closeLicenseEditor = function() {
            $scope.showLicenseEditor = false;
            $scope.parsedLicense = LicenseParser.parseLicense($scope.cloudCredentials.license);
        };

        $scope.save = function() {
            if ($scope.proxySettings.host) {
                WT1.event("fm-use-proxy", {
                    asAuth : $scope.proxySettings.username != null
                });
            }
    
            // we save the proxy settings first as they may impact the other API calls
            return FMAPI.tenant.setProxySettings($scope.proxySettings).error(prefixErrorBefore("Saving proxy settings", setErrorInScope.bind($scope)))
                .success(() => {
                    FMAPI.tenant.setCloudTags($scope.cloudTags).error(prefixErrorBefore("Saving cloud tags", setErrorInScope.bind($scope)));
                    $scope.saveCloudCredentials();
                }
            );
        }

        $scope.updateAfterSave = function () {
            FMAPI.core.getConfiguration().error(prefixErrorBefore("Getting configuration", setErrorInScope.bind($scope)))
                .success(appConfig => {
                    $rootScope.appConfig = appConfig;
                    $state.go("tenant.view");
                });
        }

        $scope.saveCloudCredentials = function() {
            FMAPI.tenant.setCloudCredentials($scope.cloudCredentials).error(prefixErrorBefore("Saving cloud credential", setErrorInScope.bind($scope)))
                .success(function(data) {
                    if (data.anyMessage && (data.warning || data.error)) {
                        Dialogs.infoMessagesDisplayOnly($rootScope, "Saving Cloud Settings", data).then (function() {
                                $scope.updateAfterSave();
                            }
                        );
                    } else {
                        $scope.updateAfterSave();
                    }
                });
        }

        // Prefix error in order to tell the user which API call failed
        function prefixErrorBefore(prefix, callback) {
            return function(error) {
                if(error && error.detailedMessage) {
                    error.detailedMessage = prefix + " failed: " + error.detailedMessage;
                }
                return callback(...arguments);
            }
        }

        $scope.add = function() {
            var read = new FileReader();

            read.onloadend = function(event) {
                var certificate = event.target.result;
                var data = $scope.cloudCredentials;
                data.azureCertificate = btoa(certificate);
                FMAPI.tenant.uploadCertificate(data).error(setErrorInScope.bind($scope));
            };

            read.readAsBinaryString(document.getElementById("certificateUpload").files[0]);
        }
    });

}());
