(function() {
    'use strict';

    const app = angular.module('dataiku.fm.nav', []);

    app.service("TopNav", function($stateParams, $rootScope, Logger) {
        const svc = this;

        let currentPageTitle = "Dataiku FM";
        $rootScope.topNav = {item: {}};

        function getItemKey(item) {
            const type = item.type || "";
            return type + ':' + item.id;
        }

        function sameItem(item1, item2) {
            return item1 && item2 && (getItemKey(item1) == getItemKey(item2));
        }

        svc.setOverrideLeftType = function(type) {
            $rootScope.topNav.overrideLeftType = type;
        };

        svc.setPageTitle = function(title) {
            currentPageTitle = title;
            svc.refreshPageTitle();
        };

        svc.refreshPageTitle = function() {
            document.title = currentPageTitle + " | Dataiku";
        };

        /**
         * Valid "top" elements
         * Frontend only
         */
        svc.LOGIN = "LOGIN";
        svc.HOME = "HOME";
        svc.TOP_HOME = "HOME";

        /**
         * Valid item types
         * Shared with backend
         */
        svc.ITEM_INSTANCE = "INSTANCE";


        /**
         * top = which universe is highlighted in the global nav (+color for item icon)
         * left = which "sub-universe" is active (e.g. Project Home > Settings)
         * tabsType = which tabs to show on the right on secondary nav
         * tab = which tab is active on the right on secondary nav
         */
        svc.setLocation = function setLocation(top, left, tabsType, tab) {
            $rootScope.topNav.top = top;
            $rootScope.topNav.left = left;
            $rootScope.topNav.tabsType = tabsType;
            $rootScope.topNav.tab = tab;

            Logger.debug("Set location to ", $rootScope.topNav);
        };

        svc.setProjectData = function(data) {
            $rootScope.topNav.project = data;
        };

        svc.setItem = function(type, id, data) {
            Logger.debug("Set item", type, id, data);
            const oldItem = $rootScope.topNav.item;
            const newItem = {
                type: type,
                id: id,
                data: data
            }
            const same = svc.sameItem(oldItem, newItem);
            $rootScope.topNav.item = newItem;
            // If we change item and don't have data yet, show "Loading..." state
            if (type && !same && !data) {
                $rootScope.topNav.item.data = {name: "Loading ...", loading: true};
            }
        };

        svc.getItem = function() {
            return $rootScope.topNav.item;
        };

        svc.setNoItem = function() {
            svc.setItem(null, null, null);
        };

        // Only changes the tab, nothing elses
        svc.setTab = function(tab) {
            $rootScope.topNav.tab = tab;
        };

        svc.sameItem = function(item1, item2) {
            return item1 && item2 && (getItemKey(item1) == getItemKey(item2));
        };

        svc.isShowHomePageNavSearch = function() {
            return ('showSearchInNav' in $stateParams) && !('filterBy' in $stateParams);
        };

        svc.sameItem = sameItem;
    });

    app.directive("clickNext", function() {
        return {
            scope: false,
            restrict: 'A',
            link: function(scope, element) {
                const $e = $(element);
                $e.on('click', function(evt) {
                    $e.next().trigger(evt);
                });
            }
        };
    });

    app.directive("tabModel", function($timeout, $stateParams, $state, Dialogs) {
        return {
            scope: false,
            restrict: 'A',
            link: function(scope, element, attrs) {
                const $e = $(element),
                    expr = attrs.tabModel + ' = $tab',
                    klass = attrs.tabActiveClass || 'active',
                    notify = attrs.tabModelNotify === "true",
                    disableTransition = attrs.disableTransition === "true";

                function transition(evt, e) {
                    const tab = e.getAttribute('tab-set');
                    if (disableTransition) {
                        scope.$eval.bind(scope, expr, {$tab: tab})();
                    } else {
                        $state.go('.', {selectedTab: tab}, {location: true, inherit: true, relative: $state.$current, notify: notify}).then(function() {
                            scope.$eval.bind(scope, expr, {$tab: tab})();
                        });
                    }
                }

                $e.on('click', '[tab-set]', function(evt) {
                    const that = this;
                    if (scope.hooks && scope.hooks.dirty && scope.hooks.dirty()) {
                        Dialogs.confirm(scope, 'Unsaved changes', "You have unsaved changes. Are you sure you want to leave this page ?")
                            .then(() => transition(evt, that));
                    } else {
                        scope.$apply(() => transition(evt, that));
                    }
                });

                scope.$watch(attrs.tabModel, function(val) {
                    $timeout(function() {
                        $e.find('[tab-active]').each(function() {
                            this.classList[this.getAttribute('tab-active') === val ? 'add' : 'remove'](klass);
                        });
                    }, 0);
                });
            }
        };
    });

})();