(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/edit.js
     */
    app.controller('ExportDashboardModalController', function($scope, DataikuAPI, ActivityIndicator, FutureProgressModal, WT1, DashboardFilters, DashboardFiltersUrlParams, translate) {
        /**
         * @param {Dashboard | undefined} selection when doing mass export, the selection is undefined and
         * $scope.selection.selectedObjects contains the dashboards to export
         * @param {{ massExport: boolean, from: 'EDIT' | 'VIEW' | 'LIST' }} options
         */
        $scope.init = function(selection, options) {
            // Selection can correspond to multiple dashboards or a single dashboard
            $scope.params = {};

            let filtersBySlide = [];
            // It's only possible to take into account filters when from a dashboard in view mode.
            if (options.from === 'VIEW') {
                filtersBySlide = selection.pages.map(page => DashboardFiltersUrlParams.getFiltersQueryStringValue(DashboardFilters.getActiveGlobalFilters(page.cid) || []));
            }

            if (options.massExport == true) {
                if ($scope.selection.selectedObjects.length > 0) {
                    $scope.projectKey = $scope.selection.selectedObjects[0].projectKey;
                } else {
                    $scope.projectKey = null;
                }
                $scope.params.dashboards = $scope.selection.selectedObjects.map(function(dashboard) {
                    return { dashboardId: dashboard.id, filtersBySlide, slideIndex: undefined };
                });
                if ($scope.selection.selectedObjects.length == 1) {
                    $scope.projectKey = $scope.dashboard.projectKey;
                    $scope.modalTitle = translate('DASHBOARD.EXPORT_MODAL.EXPORT_ONE_DASHBOARD', 'Export dashboard : {{dashboardName}}', { dashboardName: $scope.dashboard.name });
                } else {
                    $scope.projectKey = $scope.selection.selectedObjects.length == 0 ? null : $scope.selection.selectedObjects[0].projectKey;
                    $scope.modalTitle = translate('DASHBOARD.EXPORT_MODAL.EXPORT_MULTIPLE_DASHBOARDS', 'Export a list of {{numberOfDashboards}} dashboards', { numberOfDashboards: $scope.selection.selectedObjects.length });
                }
            } else {
                $scope.projectKey = $scope.dashboard.projectKey;
                $scope.params.dashboards = [ { dashboardId: $scope.dashboard.id, filtersBySlide, slideIndex: undefined } ];
                $scope.modalTitle = translate('DASHBOARD.EXPORT_MODAL.EXPORT_ONE_DASHBOARD', 'Export dashboard : {{dashboardName}}', { dashboardName: $scope.dashboard.name });
            }
        };

        $scope.exportDashboard = function() {
            WT1.event('dashboard-exported-from-dashboard-universe', {
                format: $scope.params.exportFormat
            });

            if ($scope.params.exportOnlyCurrentSlide && $scope.params.dashboards.length == 1) {
                $scope.params.dashboards[0].slideIndex = $scope.pageIdx;
            }
            DataikuAPI.dashboards.export($scope.projectKey, $scope.params.exportFormat, $scope.params.dashboards)
                .error(setErrorInScope.bind($scope))
                .success(function(resp) {
                    FutureProgressModal.show($scope, resp, translate('DASHBOARD.EXPORT_MODAL.PROGRESS_MODAL', 'Export dashboard')).then(function(result) {
                        if (result) { // undefined in case of abort
                            downloadURL(DataikuAPI.dashboards.getExportURL(result.projectKey, result.exportId));
                            ActivityIndicator.success(translate('DASHBOARD.EXPORT_MODAL.PROGRESS_MODAL.SUCCESS', 'Dashboard export(s) downloaded!'), 5000);
                        } else {
                            ActivityIndicator.error(translate('DASHBOARD.EXPORT_MODAL.PROGRESS_MODAL.ERROR', 'Export dashboard failed'), 5000);
                        }
                        $scope.resolveModal();
                    });
                });
        };
    });
})();
