(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This controller previously was in static/dataiku/js/simple_report/config_ui.js
    app.controller('GeometryMapChartController', function($scope, ChartTypeChangeHandler, ChartColorSelection, ChartsStaticData) {

        $scope.$watch('chart.def.geoLayers', function(newValue) {
            const lastGeoLayer = newValue[newValue.length - 1];
            $scope.generateEmptyPlaceholder(lastGeoLayer);
            prepareGeoLayers(newValue);
        }, true);


        $scope.acceptMeasure = data => ChartTypeChangeHandler.scatterAccept(data);

        $scope.acceptGeo = data => ChartTypeChangeHandler.acceptGeo(data);

        $scope.getUaColor = measure => ChartColorSelection.getUaColor($scope.chart.def, measure);

        $scope.removeGeometry = function(index) {
            if (!isLastGeoLayer(index)) {
                $scope.chart.def.geoLayers.splice(index, 1);
            }
        }

        $scope.sortableOptions = {
            update: function(e, ui) {
                const sortableElement = ui.item.sortable;
                preventTheLastItemFromMoving(sortableElement);
            },
            handle: '.handle'
        };

        $scope.isEmptyPlaceholder = index => isLastGeoLayer(index);

        function isLastGeoLayer(index) {
            return (index === $scope.chart.def.geoLayers.length - 1);
        }

        function preventTheLastItemFromMoving(sortableElement) {
            const lastItemIndex = sortableElement.sourceModel.length - 1;
            if ((sortableElement.index === lastItemIndex) || (sortableElement.dropindex === lastItemIndex)) {
                sortableElement.cancel();
            }
        }

        function isLayerEmpty(geoLayer) {
            return (geoLayer.geometry.length === 0 && geoLayer.uaColor.length === 0);
        }

        $scope.generateEmptyPlaceholder = function(lastGeoLayer) {
            if (!isLayerEmpty(lastGeoLayer)) {
                $scope.chart.def.geoLayers.push(ChartTypeChangeHandler.newEmptyGeoPlaceholder($scope.chart.def.geoLayers.length));
            }
        }

        function prepareGeoLayers(geoLayers) {
            for (let i = 0; i < geoLayers.length - 1; ++i) {
                if (isLayerEmpty(geoLayers[i])) {
                    geoLayers.splice(i, 1);
                } else {
                    autoCompleteGeoLayers(geoLayers[i])
                }
            }
        }

        function autoCompleteGeoLayers(geoLayer) {
            if (geoLayer.geometry.length > 0) {
                ChartTypeChangeHandler.autocompleteUA(geoLayer.geometry[0]);
            }
            if (geoLayer.uaColor.length > 0) {
                ChartTypeChangeHandler.autocompleteUA(geoLayer.uaColor[0]);
                if (geoLayer.geometry.length > 0) {
                    geoLayer.geometry[0].aggregationFunction = ChartsStaticData.GEOM_AGGREGATIONS.DEFAULT;
                }
            }
        }
    });
})();
