(function () {
  "use strict";

    angular.module("dataiku.nestedFilters").factory("FilterEditorService", FilterEditorService);

    function FilterEditorService(DataikuAPI, Logger) {
        const filterEditorService = {
            getVariables,
            internalFieldsErrorLog,
            validateAST
        };

        function getVariables(scope, recipe, stateParams) {
            const promise = recipe ? DataikuAPI.flow.recipes.generic.getVariables(recipe) :
                    DataikuAPI.flow.recipes.generic.getVariablesWithProjectKey(stateParams.projectKey);
            promise.success(function(data) {
                scope.recipeVariables = data;
            }).error(setErrorInScope.bind(scope));
        }

        function internalFieldsErrorLog(filterDesc, schema, dataset, attrs) {
            if (!filterDesc) {
                Logger.error('"filter-desc" attribute is required by directive filterEditor', attrs);
            }
            if (!schema && !dataset && !(filterDesc.$status && filterDesc.$status.schema)) {
                Logger.error('filterEditor must have either a dataset or a schema', attrs);
            }
        }

        function validateAST(scope, stateParams, lastFilterDesc, setTranslatedExpression) {
            DataikuAPI.flow.recipes.filter.validateAst(lastFilterDesc, stateParams.projectKey)
                .success(setTranslatedExpression)
                .error(setErrorInScope.bind(scope));
        }

        return filterEditorService;
    }
})();
