(function(){
    "use strict";

    const searchNotebookFieldList = {
        bindings : {
            mappingStats: "<",
            onSelectField: "<"
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-field-list/search-notebook-field-list.component.html",
        controller: function() {
            const $ctrl = this;
            $ctrl.fields = null;

            $ctrl.$onChanges = () => {
                if ($ctrl.mappingStats) {
                    const entries = Object.entries($ctrl.mappingStats.fieldStats);
                    if (entries.length > 0) {
                        const fields = [];
                        for (const [name, stats] of entries) {
                            stats.name = name;
                            stats.esTypes = stats.types.map(typeAndFormat => typeAndFormat.type)
                            fields.push(stats);
                        }
                        fields.sort((a, b) => {
                            return b.inIndexCount - a.inIndexCount || // descending
                                a.name.localeCompare(b.name); // alphabetical
                        });
                        $ctrl.fields = fields;
                    }
                }
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookFieldList", searchNotebookFieldList);
})();