(function(){
    "use strict";

    // Call with searchNotebookInitModalDirective
    const searchNotebookInitModal = {
        bindings : {
            modalControl: "<",
            connection: "<",
            onSelectedIndices: "<",
            cell: "<"
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-init-modal/search-notebook-init-modal.component.html",
        controller: function($element, $scope, DataikuAPI, $stateParams, $timeout) {
            const $ctrl = this;
            $ctrl.indicesScope = { indices: null };

            $ctrl.selectedScope = null;

            $ctrl.indexPatternScope = {
                pattern: null,
                indices: null
            }

            $ctrl.datasetScope = {
                datasets: null,
                selectedDatasets: [],
            }

            $ctrl.$onInit = () => {
                if ($ctrl.cell) {
                    $ctrl.selectedScope = $ctrl.cell.searchScope.scope;
                } else {
                    // Trigger click on target input to display the dropdown menu.
                    // Wait a bit till the modal height is computed so that the dropdown could be properly displayed.
                    $timeout(() => {
                        document.querySelector('#search-notebook-init-modal .dku-select-button').click();
                    }, 400);
                }
            };

            const resolveIndexForDatasets = (datasets) => datasets.map(d => d.$dataset.params.index).join(",");

            // ElasticSearch has a default http line length of 4096 bytes (the URL, not the body).
            // An error from ES will be raised if that line is too long, so we add a little check...
            $ctrl.checkResolvedIndexTooLong = () => {
                let resolvedIndex = "";
                switch ($ctrl.selectedScope) {
                    case "INDICES":
                        if ($ctrl.indicesScope.indices) {
                            resolvedIndex = $ctrl.indicesScope.indices.filter(i => i.$selected).map(m => m.name).join(",");
                        }
                        break;
                    case "DATASETS":
                        resolvedIndex = resolveIndexForDatasets($ctrl.datasetScope.selectedDatasets);
                        break;
                    case "INDEX_PATTERN":
                        resolvedIndex = $ctrl.indexPatternScope.pattern || "";
                        break;
                    default:
                        return false;
                }
                return resolvedIndex.length > 3500; // as a random value to account for adding the host, port, + other stuff
            }

            $ctrl.selectSearchScope = () => {
                const newNotebookCell = angular.copy($ctrl.cell) || {};
                switch ($ctrl.selectedScope) {
                    case "INDICES":
                        newNotebookCell.searchScope = {
                            scope: $ctrl.selectedScope,
                            indices: $ctrl.indicesScope.indices.filter(i => i.$selected).map(m => m.name) // indices are kept in $selection due to directives...
                        };
                        newNotebookCell.$resolvedIndex = newNotebookCell.searchScope.indices.join(",");
                        break;
                    case "DATASETS":
                        newNotebookCell.searchScope = {
                            scope: $ctrl.selectedScope,
                            datasets: $ctrl.datasetScope.selectedDatasets.map(d => d.$dataset.smartName)
                        };
                        newNotebookCell.$resolvedIndex = resolveIndexForDatasets($ctrl.datasetScope.selectedDatasets);
                        break;
                    case "INDEX_PATTERN":
                        newNotebookCell.searchScope = {
                            scope: $ctrl.selectedScope,
                            indexPattern: $ctrl.indexPatternScope.pattern
                        };
                        newNotebookCell.$resolvedIndex = $ctrl.indexPatternScope.pattern;
                        break;
                    default:
                        throw new Error("Unknown scope: " + $ctrl.selectedScope);
                }

                DataikuAPI.searchNotebooks.inferSchema($stateParams.projectKey, $ctrl.connection, newNotebookCell.$resolvedIndex)
                    .then(({data}) => {
                        $ctrl.onSelectedIndices(newNotebookCell, data.mappingStats, data.inferredSchema, true);
                        $ctrl.modalControl.resolve();
                    })
                    .catch(setErrorInScope.bind($scope));
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookInitModal", searchNotebookInitModal);
})();