class EmbeddingDriftSettings(object):
    """Base class for holding embedding drift settings."""

    def __init__(self, should_be_computed=False):
        """
        :param bool should_be_computed: Flag to enable or disable the drift computation.
        """
        self.should_be_computed = should_be_computed
        self.params = None

    def with_params(self, params=None):
        """Sets the detailed parameters for the drift computation.

        :param dict params: Optional dictionary of specific drift parameters.
        :return: The instance of the class.
        :rtype: EmbeddingDriftSettings
        """
        self.params = params
        return self


class TextDriftSettings(EmbeddingDriftSettings):
    """Holds settings specific to text drift analysis."""
    pass


class ImageDriftSettings(EmbeddingDriftSettings):
    """Holds settings specific to image drift analysis."""

    def __init__(self, should_be_computed=False):
        """Initializes the image drift settings."""
        super(ImageDriftSettings, self).__init__(should_be_computed)
        self.managed_folder_smart_id_cur = None
        self.managed_folder_smart_id_ref = None

    def with_params(self, params=None,
                    managed_folder_smart_id_cur=None,
                    managed_folder_smart_id_ref=None):
        """Sets the detailed parameters for image drift computation.

        :param dict params: Optional dictionary of specific drift parameters.
        :param str managed_folder_smart_id_cur: Optional smart ID of the folder containing the current images.
        :param str managed_folder_smart_id_ref: Optional smart ID of the folder containing the reference images.
        :return: The instance of the class.
        :rtype: ImageDriftSettings
        """
        super(ImageDriftSettings, self).with_params(params)
        self.managed_folder_smart_id_cur = managed_folder_smart_id_cur
        self.managed_folder_smart_id_ref = managed_folder_smart_id_ref
        return self
