/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.AutoValue_HttpConnectionManager;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.Filter;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.VirtualHost;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
abstract class HttpConnectionManager {
    HttpConnectionManager() {
    }

    abstract long httpMaxStreamDurationNano();

    @Nullable
    abstract String rdsName();

    @Nullable
    abstract ImmutableList<VirtualHost> virtualHosts();

    @Nullable
    abstract ImmutableList<Filter.NamedFilterConfig> httpFilterConfigs();

    static HttpConnectionManager forRdsName(long httpMaxStreamDurationNano, String rdsName, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        Preconditions.checkNotNull(rdsName, "rdsName");
        return HttpConnectionManager.create(httpMaxStreamDurationNano, rdsName, null, httpFilterConfigs);
    }

    static HttpConnectionManager forVirtualHosts(long httpMaxStreamDurationNano, List<VirtualHost> virtualHosts, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        Preconditions.checkNotNull(virtualHosts, "virtualHosts");
        return HttpConnectionManager.create(httpMaxStreamDurationNano, null, virtualHosts, httpFilterConfigs);
    }

    private static HttpConnectionManager create(long httpMaxStreamDurationNano, @Nullable String rdsName, @Nullable List<VirtualHost> virtualHosts, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        return new AutoValue_HttpConnectionManager(httpMaxStreamDurationNano, rdsName, virtualHosts == null ? null : ImmutableList.copyOf(virtualHosts), httpFilterConfigs == null ? null : ImmutableList.copyOf(httpFilterConfigs));
    }
}

