/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.DirectCodecFactory;
import org.apache.parquet.hadoop.codec.ZstandardCodec;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.ConfigurationUtil;

public class CodecFactory
implements CompressionCodecFactory {
    protected static final Map<String, CompressionCodec> CODEC_BY_NAME = Collections.synchronizedMap(new HashMap());
    private final Map<CompressionCodecName, BytesCompressor> compressors = new HashMap<CompressionCodecName, BytesCompressor>();
    private final Map<CompressionCodecName, BytesDecompressor> decompressors = new HashMap<CompressionCodecName, BytesDecompressor>();
    protected final ParquetConfiguration conf;
    protected final int pageSize;
    @Deprecated
    protected final Configuration configuration;
    static final BytesDecompressor NO_OP_DECOMPRESSOR = new BytesDecompressor(){

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int decompressedSize) {
            Preconditions.checkArgument(compressedSize == decompressedSize, "Non-compressed data did not have matching compressed and decompressed sizes.");
            Preconditions.checkArgument(input.remaining() >= compressedSize, "Not enough bytes available in the input buffer");
            int origLimit = input.limit();
            input.limit(input.position() + compressedSize);
            output.put(input);
            input.limit(origLimit);
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int decompressedSize) {
            return bytes;
        }

        @Override
        public void release() {
        }
    };
    static final BytesCompressor NO_OP_COMPRESSOR = new BytesCompressor(){

        @Override
        public BytesInput compress(BytesInput bytes) {
            return bytes;
        }

        @Override
        public CompressionCodecName getCodecName() {
            return CompressionCodecName.UNCOMPRESSED;
        }

        @Override
        public void release() {
        }
    };

    public CodecFactory(Configuration configuration, int pageSize) {
        this(new HadoopParquetConfiguration(configuration), pageSize);
    }

    public CodecFactory(ParquetConfiguration configuration, int pageSize) {
        this.configuration = configuration instanceof HadoopParquetConfiguration ? ((HadoopParquetConfiguration)configuration).getConfiguration() : null;
        this.conf = configuration;
        this.pageSize = pageSize;
    }

    public static CodecFactory createDirectCodecFactory(Configuration config, ByteBufferAllocator allocator, int pageSize) {
        return new DirectCodecFactory(config, allocator, pageSize);
    }

    @Override
    public BytesCompressor getCompressor(CompressionCodecName codecName) {
        BytesCompressor comp = this.compressors.get((Object)codecName);
        if (comp == null) {
            comp = this.createCompressor(codecName);
            this.compressors.put(codecName, comp);
        }
        return comp;
    }

    @Override
    public BytesDecompressor getDecompressor(CompressionCodecName codecName) {
        BytesDecompressor decomp = this.decompressors.get((Object)codecName);
        if (decomp == null) {
            decomp = this.createDecompressor(codecName);
            this.decompressors.put(codecName, decomp);
        }
        return decomp;
    }

    protected BytesCompressor createCompressor(CompressionCodecName codecName) {
        CompressionCodec codec = this.getCodec(codecName);
        return codec == null ? NO_OP_COMPRESSOR : new HeapBytesCompressor(codecName, codec);
    }

    protected BytesDecompressor createDecompressor(CompressionCodecName codecName) {
        CompressionCodec codec = this.getCodec(codecName);
        return codec == null ? NO_OP_DECOMPRESSOR : new HeapBytesDecompressor(codec);
    }

    protected CompressionCodec getCodec(CompressionCodecName codecName) {
        String codecClassName = codecName.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        String codecCacheKey = this.cacheKey(codecName);
        CompressionCodec codec = CODEC_BY_NAME.get(codecCacheKey);
        if (codec != null) {
            return codec;
        }
        try {
            Class<?> codecClass;
            try {
                codecClass = Class.forName(codecClassName);
            }
            catch (ClassNotFoundException e) {
                codecClass = new Configuration(false).getClassLoader().loadClass(codecClassName);
            }
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)ConfigurationUtil.createHadoopConfiguration(this.conf));
            CODEC_BY_NAME.put(codecCacheKey, codec);
            return codec;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("Class " + codecClassName + " was not found", e);
        }
    }

    private String cacheKey(CompressionCodecName codecName) {
        String level = null;
        switch (codecName) {
            case GZIP: {
                level = this.conf.get("zlib.compress.level");
                break;
            }
            case BROTLI: {
                level = this.conf.get("compression.brotli.quality");
                break;
            }
            case ZSTD: {
                level = this.conf.get("parquet.compression.codec.zstd.level");
                break;
            }
        }
        String codecClass = codecName.getHadoopCompressionCodecClassName();
        return level == null ? codecClass : codecClass + ":" + level;
    }

    @Override
    public void release() {
        for (BytesCompressor compressor : this.compressors.values()) {
            compressor.release();
        }
        this.compressors.clear();
        for (BytesDecompressor decompressor : this.decompressors.values()) {
            decompressor.release();
        }
        this.decompressors.clear();
    }

    @Deprecated
    public static abstract class BytesDecompressor
    implements CompressionCodecFactory.BytesInputDecompressor {
        @Override
        public abstract BytesInput decompress(BytesInput var1, int var2) throws IOException;

        @Override
        public abstract void decompress(ByteBuffer var1, int var2, ByteBuffer var3, int var4) throws IOException;

        @Override
        public abstract void release();
    }

    @Deprecated
    public static abstract class BytesCompressor
    implements CompressionCodecFactory.BytesInputCompressor {
        @Override
        public abstract BytesInput compress(BytesInput var1) throws IOException;

        @Override
        public abstract CompressionCodecName getCodecName();

        @Override
        public abstract void release();
    }

    class HeapBytesCompressor
    extends BytesCompressor {
        private final CompressionCodec codec;
        private final Compressor compressor;
        private final ByteArrayOutputStream compressedOutBuffer;
        private final CompressionCodecName codecName;

        HeapBytesCompressor(CompressionCodecName codecName, CompressionCodec codec) {
            this.codecName = codecName;
            this.codec = Objects.requireNonNull(codec);
            this.compressor = CodecPool.getCompressor((CompressionCodec)codec);
            this.compressedOutBuffer = new ByteArrayOutputStream(CodecFactory.this.pageSize);
        }

        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            this.compressedOutBuffer.reset();
            if (this.compressor != null) {
                this.compressor.reset();
            }
            try (CompressionOutputStream cos = this.codec.createOutputStream((OutputStream)this.compressedOutBuffer, this.compressor);){
                bytes.writeAllTo((OutputStream)cos);
                cos.finish();
            }
            return BytesInput.from(this.compressedOutBuffer);
        }

        @Override
        public void release() {
            if (this.compressor != null) {
                CodecPool.returnCompressor((Compressor)this.compressor);
            }
        }

        @Override
        public CompressionCodecName getCodecName() {
            return this.codecName;
        }
    }

    class HeapBytesDecompressor
    extends BytesDecompressor {
        private final CompressionCodec codec;
        private final Decompressor decompressor;

        HeapBytesDecompressor(CompressionCodec codec) {
            this.codec = Objects.requireNonNull(codec);
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int decompressedSize) throws IOException {
            BytesInput decompressed;
            if (this.decompressor != null) {
                this.decompressor.reset();
            }
            CompressionInputStream is = this.codec.createInputStream((InputStream)bytes.toInputStream(), this.decompressor);
            if (this.codec instanceof ZstandardCodec) {
                decompressed = BytesInput.copy(BytesInput.from((InputStream)is, decompressedSize));
                is.close();
            } else {
                decompressed = BytesInput.from((InputStream)is, decompressedSize);
            }
            return decompressed;
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int decompressedSize) throws IOException {
            Preconditions.checkArgument(input.remaining() >= compressedSize, "Not enough bytes available in the input buffer");
            int origLimit = input.limit();
            int origPosition = input.position();
            input.limit(origPosition + compressedSize);
            ByteBuffer decompressed = this.decompress(BytesInput.from(input), decompressedSize).toByteBuffer();
            output.put(decompressed);
            input.limit(origLimit);
            input.position(origPosition + compressedSize);
        }

        @Override
        public void release() {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
            }
        }
    }
}

