/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.models.export.ExportFile;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesService;
import com.dataiku.gh.core.services.export.IExportService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CustomPagesController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ICustomPagesService customPagesService;
    @Autowired
    private IExportService exportService;

    @AuditedCall(value={"msgType", "custom-page-get", "customPageId", "${customPageId}"})
    @RequestMapping(value={"/api/custom-pages/get"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String customPageId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        CustomPagesController.writeJSON((HttpServletResponse)resp, (Object)this.customPagesService.getCustomPage(authCtx, customPageId));
    }

    @AuditedCall(value={"msgType", "custom-pages-list"})
    @RequestMapping(value={"/api/custom-pages/list"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        CustomPagesController.writeJSON((HttpServletResponse)resp, this.customPagesService.listCustomPages(authCtx));
    }

    @AuditedCall(value={"msgType", "custom-page-export", "customPageId", "${customPageId}"})
    @RequestMapping(value={"/api/custom-pages/export"}, method={RequestMethod.POST})
    public void customPageExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String customPageId, @RequestParam List<ArtifactFilter> artifactFilters) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        ExportFile file = this.exportService.exportCustomPage(authCtx, customPageId, artifactFilters);
        this.writeStream(resp, file.data, file.mimeType.mimeType, file.fileName);
    }
}

