/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.security.mappings.IUsersMappingsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AdminUsersMappingsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IUsersMappingsService usersMappingsService;

    @AuditedCall(value={"msgType", "users-mappings-sync"})
    @RequestMapping(value={"/api/admin/users-mappings/sync"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.USERS_MAPPING_SYNC)
    public void get(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        this.usersMappingsService.syncAll();
        AdminUsersMappingsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

