/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.governance;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceEffectiveAction;
import com.dataiku.gh.core.models.governance.IInputGovernanceSettingsVisitor;
import com.dataiku.j2ts.annotations.UIModel;
import javax.annotation.Nullable;

@PolyJSON(value={@Mapping(value=ProjectSettings.class, type="project"), @Mapping(value=ExistingProjectSettings.class, type="existing-project"), @Mapping(value=ModelSettings.class, type="model"), @Mapping(value=BundleSettings.class, type="bundle"), @Mapping(value=ModelVersionSettings.class, type="model-version")})
@UIModel
public abstract class InputGovernanceSettings {
    public abstract void accept(IInputGovernanceSettingsVisitor var1);

    public static class ModelVersionSettings
    extends InputGovernanceSettings {
        public static final String TYPE = "model-version";
        public AutoGovernanceEffectiveAction action = AutoGovernanceEffectiveAction.DO_NOTHING;
        @Nullable
        public Artifact prefillArtifact;
        @Nullable
        public BlueprintVersionId blueprintVersionId;

        public static ModelVersionSettings build(AutoGovernanceEffectiveAction action, @Nullable BlueprintVersionId blueprintVersionId, @Nullable Artifact prefillArtifact) {
            ModelVersionSettings settings = new ModelVersionSettings();
            settings.action = action;
            settings.blueprintVersionId = blueprintVersionId;
            settings.prefillArtifact = prefillArtifact;
            return settings;
        }

        public static ModelVersionSettings build(AutoGovernanceEffectiveAction action, @Nullable BlueprintVersionId blueprintVersionId) {
            return ModelVersionSettings.build(action, blueprintVersionId, null);
        }

        @Override
        public void accept(IInputGovernanceSettingsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BundleSettings
    extends InputGovernanceSettings {
        public static final String TYPE = "bundle";
        @Nullable
        public Artifact prefillArtifact;
        public AutoGovernanceEffectiveAction action = AutoGovernanceEffectiveAction.DO_NOTHING;
        @Nullable
        public BlueprintVersionId blueprintVersionId;

        public static BundleSettings build(AutoGovernanceEffectiveAction action, @Nullable BlueprintVersionId blueprintVersionId, @Nullable Artifact prefillArtifact) {
            BundleSettings settings = new BundleSettings();
            settings.action = action;
            settings.blueprintVersionId = blueprintVersionId;
            settings.prefillArtifact = prefillArtifact;
            return settings;
        }

        public static BundleSettings build(AutoGovernanceEffectiveAction action, @Nullable BlueprintVersionId blueprintVersionId) {
            return BundleSettings.build(action, blueprintVersionId, null);
        }

        @Override
        public void accept(IInputGovernanceSettingsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ModelSettings
    extends InputGovernanceSettings {
        public static final String TYPE = "model";
        @Nullable
        public Artifact prefillArtifact;
        public AutoGovernanceEffectiveAction action = AutoGovernanceEffectiveAction.DO_NOTHING;
        @Nullable
        public BlueprintVersionId blueprintVersionId;
        @Nullable
        public ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration modelAutoGovernanceConfiguration;

        public static ModelSettings build(AutoGovernanceEffectiveAction action, @Nullable BlueprintVersionId blueprintVersionId, @Nullable Artifact prefillArtifact) {
            ModelSettings settings = new ModelSettings();
            settings.action = action;
            settings.blueprintVersionId = blueprintVersionId;
            settings.prefillArtifact = prefillArtifact;
            return settings;
        }

        public static ModelSettings build(AutoGovernanceEffectiveAction action, @Nullable BlueprintVersionId blueprintVersionId) {
            return ModelSettings.build(action, blueprintVersionId, null);
        }

        @Override
        public void accept(IInputGovernanceSettingsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ExistingProjectSettings
    extends CommonProjectSettings {
        public static final String TYPE = "existing-project";
        public String artifactId;

        public static ExistingProjectSettings build(String projectExistingArtifactId) {
            ExistingProjectSettings settings = new ExistingProjectSettings();
            settings.artifactId = projectExistingArtifactId;
            return settings;
        }

        @Override
        public void accept(IInputGovernanceSettingsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ProjectSettings
    extends CommonProjectSettings {
        public static final String TYPE = "project";
        @Nullable
        public Artifact prefillArtifact;
        public AutoGovernanceEffectiveAction action = AutoGovernanceEffectiveAction.DO_NOTHING;
        @Nullable
        public BlueprintVersionId blueprintVersionId;
        @Nullable
        public String businessInitiativeArtifactId;

        public static ProjectSettings build(AutoGovernanceEffectiveAction action, @Nullable BlueprintVersionId blueprintVersionId, @Nullable String businessInitiativeArtifactId, @Nullable Artifact prefillArtifact) {
            ProjectSettings settings = new ProjectSettings();
            settings.action = action;
            settings.blueprintVersionId = blueprintVersionId;
            settings.businessInitiativeArtifactId = businessInitiativeArtifactId;
            settings.prefillArtifact = prefillArtifact;
            return settings;
        }

        public static ProjectSettings build(AutoGovernanceEffectiveAction action, @Nullable BlueprintVersionId blueprintVersionId, @Nullable String businessInitiativeArtifactId) {
            return ProjectSettings.build(action, blueprintVersionId, businessInitiativeArtifactId, null);
        }

        @Override
        public void accept(IInputGovernanceSettingsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static abstract class CommonProjectSettings
    extends InputGovernanceSettings {
        @Nullable
        public ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration projectAutoGovernanceConfiguration;
    }
}

