/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.signoff;

import com.dataiku.gh.core.models.security.UsersContainer;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.visitors.ISignoffConfigurationVisitor;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.Objects;

public class SignoffUser {
    public String addedBy;
    public String addedOn;
    @UINullable
    public Boolean delegated;
    public UsersContainer usersContainer;

    public void accept(ISignoffConfigurationVisitor visitor) {
        this.usersContainer.accept(visitor);
        visitor.visit(this);
    }

    public void updateAddedBy(String addedBy) {
        this.addedBy = Objects.requireNonNull(addedBy, "AddedBy is required");
        this.addedOn = DateUtils.now();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignoffUser that = (SignoffUser)o;
        return Objects.equals(this.addedBy, that.addedBy) && Objects.equals(this.addedOn, that.addedOn) && Objects.equals(this.delegated, that.delegated) && Objects.equals(this.usersContainer, that.usersContainer);
    }

    public int hashCode() {
        return Objects.hash(this.addedBy, this.addedOn, this.delegated, this.usersContainer);
    }
}

