/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV11000AndV12199;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV12000
extends Migration {
    @Override
    public void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        if (providedObjectsFolder == null) {
            throw new ValidationException("Migration " + this.getClass().getSimpleName() + " is expecting a provided object folder");
        }
        long migrationTS = this.getMigrationTimestamp();
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        Long actionId = MigrationEntitiesUtilsBetweenV11000AndV12199.createMigrationAction(jdbcTemplate, migrationTS);
        List selectRoles = dbMigrationDAO.getJdbcTemplate().queryForList("SELECT role_id FROM roles");
        Set<String> existingRoles = selectRoles.stream().filter(rolesMap -> rolesMap.get("role_id") instanceof String).map(rolesMap -> (String)rolesMap.get("role_id")).collect(Collectors.toSet());
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprint(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"project_deployer_infrastructure", "blueprint.json"}), "bp.system.project_deployer_infrastructure", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"project_deployer_infrastructure", "blueprint_version_default.json"}), "bp.system.project_deployer_infrastructure", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintPermissions(jdbcTemplate, MigrationEntitiesUtilsBetweenV11000AndV12199.loadBlueprintPermissionsAndRemovePermissionsForDeletedRoles(DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"project_deployer_infrastructure", "blueprint_permissions.json"}), existingRoles), "bp.system.project_deployer_infrastructure", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprint(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"project_deployer_deployment", "blueprint.json"}), "bp.system.project_deployer_deployment", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"project_deployer_deployment", "blueprint_version_default.json"}), "bp.system.project_deployer_deployment", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintPermissions(jdbcTemplate, MigrationEntitiesUtilsBetweenV11000AndV12199.loadBlueprintPermissionsAndRemovePermissionsForDeletedRoles(DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"project_deployer_deployment", "blueprint_permissions.json"}), existingRoles), "bp.system.project_deployer_deployment", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprint(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"api_deployer_infrastructure", "blueprint.json"}), "bp.system.api_deployer_infrastructure", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"api_deployer_infrastructure", "blueprint_version_default.json"}), "bp.system.api_deployer_infrastructure", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintPermissions(jdbcTemplate, MigrationEntitiesUtilsBetweenV11000AndV12199.loadBlueprintPermissionsAndRemovePermissionsForDeletedRoles(DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"api_deployer_infrastructure", "blueprint_permissions.json"}), existingRoles), "bp.system.api_deployer_infrastructure", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprint(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"api_deployer_deployment", "blueprint.json"}), "bp.system.api_deployer_deployment", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"api_deployer_deployment", "blueprint_version_default.json"}), "bp.system.api_deployer_deployment", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintPermissions(jdbcTemplate, MigrationEntitiesUtilsBetweenV11000AndV12199.loadBlueprintPermissionsAndRemovePermissionsForDeletedRoles(DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"api_deployer_deployment", "blueprint_permissions.json"}), existingRoles), "bp.system.api_deployer_deployment", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_bundle", "blueprint_version_default.json"}), "bp.system.dataiku_bundle", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_saved_model_version", "blueprint_version_default.json"}), "bp.system.dataiku_saved_model_version", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_project", "blueprint_version_default.json"}), "bp.system.govern_project", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_bundle", "blueprint_version_default.json"}), "bp.system.govern_bundle", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV11000AndV12199.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_model_version", "blueprint_version_default.json"}), "bp.system.govern_model_version", "bv.system.default", actionId, migrationTS);
    }

    @Override
    public boolean shouldPerformDbOptimizationAfterMigration() {
        return false;
    }
}

