/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.Attachments;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSort;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.signoff.EnrichedSignoff;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.context.EnrichedBlueprintVersionContext;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.relationships.IRelationshipsService;
import com.dataiku.gh.core.services.relationships.collectors.CollectorResult;
import com.dataiku.gh.core.services.relationships.handlers.IReferenceRelationshipHandler;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsDataService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.artifacts.IArtifactDAO;
import com.dataiku.gh.core.storage.artifacts.IReferenceRelationshipDAO;
import com.dataiku.gh.core.storage.auto_govern.IArtifactGovernanceSettingsDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionTraceDAO;
import com.dataiku.gh.core.storage.roles.assignments.IBlueprintRoleAssignmentsDAO;
import com.dataiku.gh.core.storage.roles.permissions.IBlueprintPermissionsDAO;
import com.dataiku.gh.core.storage.search.IArtifactSearchDAO;
import com.dataiku.gh.core.storage.signoff.ISignoffDAO;
import com.dataiku.gh.core.storage.signoff.ISignoffsConfigurationsDAO;
import com.dataiku.gh.core.storage.sql.search.PartialEnrichedArtifact;
import com.dataiku.gh.core.storage.subscriptions.ISubscriptionDAO;
import com.dataiku.gh.core.storage.uploaded_files.IUploadedFileRelationshipDAO;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactsDataService
implements IArtifactsDataService {
    @Autowired
    private IArtifactDAO artifactDAO;
    @Autowired
    private IBlueprintDAO blueprintDAO;
    @Autowired
    private IBlueprintVersionDAO blueprintVersionDAO;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IBlueprintVersionTraceDAO blueprintVersionTraceDAO;
    @Autowired
    private IReferenceRelationshipDAO referenceRelationshipDAO;
    @Autowired
    private IUploadedFileRelationshipDAO uploadedFileRelationshipDAO;
    @Autowired
    private IRelationshipsService relationshipsService;
    @Autowired
    private IBlueprintRoleAssignmentsDAO blueprintRoleAssignmentsDAO;
    @Autowired
    private IBlueprintPermissionsDAO blueprintPermissionsDAO;
    @Autowired
    private IArtifactSearchDAO artifactSearchDAO;
    @Autowired
    private ISignoffDAO signoffDAO;
    @Autowired
    private ISignoffsConfigurationsDAO signoffsConfigurationsDAO;
    @Autowired
    private IReferenceRelationshipHandler referenceRelationshipHandler;
    @Autowired
    private ISubscriptionsDataService subscriptionsDataService;
    @Autowired
    private ISubscriptionDAO subscriptionDAO;
    @Autowired
    private IArtifactGovernanceSettingsDAO autoGovernConfigurationDAO;

    @Override
    @GHMandatoryTransaction
    public EnrichedArtifact getArtifact(String artifactId) throws IOException {
        try (EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer blueprintVersionCache = EnrichedBlueprintVersionContext.attachNewContextOrKeepExistingOne();){
            EnrichedArtifact enrichedArtifact = this.mapPartialEnrichedArtifactToEnrichedArtifact(blueprintVersionCache, (PartialEnrichedArtifact)this.artifactDAO.getMandatory(artifactId));
            return enrichedArtifact;
        }
    }

    @Override
    @GHMandatoryTransaction
    public EnrichedArtifact getArtifactOrNull(String artifactId) throws IOException {
        try (EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer blueprintVersionCache = EnrichedBlueprintVersionContext.attachNewContextOrKeepExistingOne();){
            EnrichedArtifact enrichedArtifact = this.mapPartialEnrichedArtifactToEnrichedArtifact(blueprintVersionCache, (PartialEnrichedArtifact)this.artifactDAO.getOrNull(artifactId));
            return enrichedArtifact;
        }
    }

    @Override
    @GHMandatoryTransaction
    public Stream<PartialEnrichedArtifact> listArtifactsStream() throws IOException {
        return this.artifactDAO.listStream();
    }

    @Override
    @GHMandatoryTransaction
    public Stream<EnrichedArtifact> searchArtifactsStream(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource, @Nullable List<ArtifactFilter> artifactFilters, @Nullable ArtifactSearchSort artifactSearchSort, @Nullable String lastArtifactId) throws IOException {
        EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer blueprintVersionCache = EnrichedBlueprintVersionContext.attachNewContextOrKeepExistingOne();
        try {
            Stream<EnrichedArtifact> stream = this.artifactSearchDAO.searchStream(artifactSearchSource, artifactFilters, artifactSearchSort, lastArtifactId).map(partialEnrichedArtifact -> this.mapPartialEnrichedArtifactToEnrichedArtifact(blueprintVersionCache, (PartialEnrichedArtifact)partialEnrichedArtifact));
            if (blueprintVersionCache != null) {
                blueprintVersionCache.close();
            }
            return stream;
        }
        catch (Throwable throwable) {
            try {
                if (blueprintVersionCache != null) {
                    try {
                        blueprintVersionCache.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (UncheckedIOException uncheckedIOException) {
                throw uncheckedIOException.getCause();
            }
        }
    }

    @Override
    @GHMandatoryTransaction
    public long searchArtifactsCount(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource, @Nullable List<ArtifactFilter> artifactFilters) throws IOException {
        return this.artifactSearchDAO.searchCount(artifactSearchSource, artifactFilters);
    }

    private EnrichedBlueprintVersion getWithCacheEnrichedBlueprintVersion_UncheckedIOException(EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer enrichedBlueprintVersionContextContainer, BlueprintVersionId blueprintVersionId) {
        EnrichedBlueprintVersion enrichedBlueprintVersion = enrichedBlueprintVersionContextContainer.getEnrichedBlueprintVersion(blueprintVersionId);
        if (enrichedBlueprintVersion == null) {
            try {
                enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(blueprintVersionId);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            enrichedBlueprintVersionContextContainer.addEnrichedBlueprintVersion(enrichedBlueprintVersion);
        }
        return enrichedBlueprintVersion;
    }

    @Override
    @GHMandatoryTransaction
    public EnrichedArtifact storeArtifact(EnrichedArtifact enrichedArtifact, boolean creation) throws IOException {
        CollectorResult relationshipsCollectorResult = this.relationshipsService.collectRelationships(enrichedArtifact);
        Artifact storableArtifact = this.enrichedArtifactToStorableArtifact(enrichedArtifact, relationshipsCollectorResult.getTransientFieldIds());
        this.lockArtifact(storableArtifact.id, storableArtifact.blueprintVersionId);
        if (creation) {
            this.artifactDAO.create(storableArtifact);
            this.relationshipsService.createRelationships(relationshipsCollectorResult);
        } else {
            CollectorResult existingRelations = CollectorResult.build(this.relationshipsService.getRelationshipsForArtifactId(enrichedArtifact.artifact.id));
            this.artifactDAO.save(storableArtifact);
            CollectorResult.CollectorResultDiff diff = CollectorResult.computeDiff(existingRelations, relationshipsCollectorResult);
            this.relationshipsService.deleteRelationships(diff.toDelete);
            this.relationshipsService.saveRelationships(diff.toSave);
            this.relationshipsService.createRelationships(diff.toCreate);
        }
        if (creation && CollectionUtils.isNotEmpty((Collection)enrichedArtifact.signoffs)) {
            for (Signoff signoff : enrichedArtifact.signoffs) {
                this.signoffDAO.create(signoff);
            }
        }
        return this.getArtifact(storableArtifact.id);
    }

    private Artifact enrichedArtifactToStorableArtifact(EnrichedArtifact ea, List<String> fieldIdsToExclude) {
        Artifact artifact = ea.artifact;
        Artifact storableArtifact = new Artifact();
        storableArtifact.id = artifact.id;
        storableArtifact.blueprintVersionId = artifact.blueprintVersionId;
        storableArtifact.name = artifact.name;
        storableArtifact.status = artifact.status;
        storableArtifact.workflow = artifact.workflow;
        storableArtifact.fields = artifact.fields.entrySet().stream().filter(entry -> !fieldIdsToExclude.contains(entry.getKey())).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        storableArtifact.attachments = new Attachments();
        return storableArtifact;
    }

    @Override
    @GHMandatoryTransaction
    public void deleteArtifact(String artifactId, BlueprintVersionId blueprintVersionId) throws IOException {
        this.lockArtifact(artifactId, blueprintVersionId);
        for (EnrichedSignoff signoffToDelete : this.signoffDAO.listByArtifact(artifactId)) {
            this.signoffDAO.delete(signoffToDelete.signoff.signoffId);
        }
        this.subscriptionsDataService.deleteForArtifact(artifactId);
        CollectorResult existingRelations = CollectorResult.build(this.relationshipsService.getRelationshipsForArtifactId(artifactId));
        existingRelations.getReferenceRelationships().addAll(this.referenceRelationshipHandler.getRelationshipsByEntityId(artifactId));
        if (this.autoGovernConfigurationDAO.exists(artifactId)) {
            this.autoGovernConfigurationDAO.delete(artifactId);
        }
        this.relationshipsService.deleteRelationships(existingRelations);
        this.artifactDAO.delete(artifactId);
    }

    @Override
    public void lockArtifact(String artifactId, BlueprintVersionId blueprintVersionId) throws IOException {
        if (!SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(blueprintVersionId.blueprintId)) {
            this.blueprintDAO.lock(blueprintVersionId.blueprintId);
            this.blueprintRoleAssignmentsDAO.lock(blueprintVersionId.blueprintId);
            this.blueprintPermissionsDAO.lock(blueprintVersionId.blueprintId);
            this.blueprintVersionDAO.lock(blueprintVersionId);
            this.blueprintVersionTraceDAO.lock(blueprintVersionId);
            this.signoffsConfigurationsDAO.lockByBlueprintVersion(blueprintVersionId);
        }
        this.artifactDAO.lock(artifactId);
        this.referenceRelationshipDAO.lockRelationshipsForArtifactId(artifactId);
        this.uploadedFileRelationshipDAO.lockRelationshipsForArtifactId(artifactId);
        this.signoffDAO.lockByArtifact(artifactId);
        this.subscriptionDAO.lockByArtifact(artifactId);
        this.autoGovernConfigurationDAO.lock(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    public List<EnrichedArtifact> getArtifactAndAncestry(String artifactId) throws IOException {
        try (EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer blueprintVersionCache = EnrichedBlueprintVersionContext.attachNewContextOrKeepExistingOne();){
            List<EnrichedArtifact> list = this.artifactDAO.getEnrichedArtifactAndAncestry(artifactId).stream().map(partial -> this.mapPartialEnrichedArtifactToEnrichedArtifact(blueprintVersionCache, (PartialEnrichedArtifact)partial)).filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<EnrichedArtifact> getArtifactAndAncestryOfDataikuArtifact(EnrichedArtifact artifact) throws IOException {
        ArrayList<EnrichedArtifact> artifactAndAncestry = new ArrayList<EnrichedArtifact>();
        artifactAndAncestry.add(artifact);
        int MAXIMAL_ANCESTRY_DEGREE = 2;
        String parentId = (String)artifact.artifact.fields.get(artifact.blueprintVersion.hierarchicalParentFieldId);
        for (int parentFetchCounter = 0; parentId != null && parentFetchCounter < 2; ++parentFetchCounter) {
            artifact = this.getArtifact(parentId);
            artifactAndAncestry.add(artifact);
            parentId = (String)artifact.artifact.fields.get(artifact.blueprintVersion.hierarchicalParentFieldId);
        }
        return artifactAndAncestry;
    }

    @Nullable
    private EnrichedArtifact mapPartialEnrichedArtifactToEnrichedArtifact(EnrichedBlueprintVersionContext.EnrichedBlueprintVersionContextContainer enrichedBlueprintVersionContextContainer, @Nullable PartialEnrichedArtifact partialEnrichedArtifact) {
        if (partialEnrichedArtifact == null) {
            return null;
        }
        BlueprintVersionId blueprintVersionId = partialEnrichedArtifact.artifact.blueprintVersionId;
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getWithCacheEnrichedBlueprintVersion_UncheckedIOException(enrichedBlueprintVersionContextContainer, blueprintVersionId);
        return EnrichedArtifact.build(enrichedBlueprintVersion.blueprint, enrichedBlueprintVersion.blueprintVersion, enrichedBlueprintVersion.blueprintVersionTrace, enrichedBlueprintVersion.blueprintRoleAssignments, partialEnrichedArtifact.artifactRoleAssignments, enrichedBlueprintVersion.blueprintPermissions, partialEnrichedArtifact.artifact, partialEnrichedArtifact.signoffs, partialEnrichedArtifact.enrichedArtifactDetails);
    }
}

