/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships.collectors;

import com.dataiku.gh.core.models.relationships.FieldRelationshipData;
import com.dataiku.gh.core.models.relationships.ListFieldRelationshipDataDetails;
import com.dataiku.gh.core.models.relationships.PlainFieldRelationshipDataDetails;
import com.dataiku.gh.core.models.relationships.UploadedFileRelationship;
import com.dataiku.gh.core.visitors.IFieldAndListValueVisitor;
import com.dataiku.gh.core.visitors.IFieldValueVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

class UploadedFilesRelationshipFieldCollector
implements IFieldValueVisitor {
    private final String from;
    private final String fieldId;
    public List<UploadedFileRelationship> relationships = new ArrayList<UploadedFileRelationship>();

    UploadedFilesRelationshipFieldCollector(String from, String fieldId) {
        this.from = from;
        this.fieldId = fieldId;
    }

    @Override
    public void visit(String stringFieldValue) {
        FieldRelationshipData fieldRelationshipData = new FieldRelationshipData();
        fieldRelationshipData.fieldId = this.fieldId;
        fieldRelationshipData.details = new PlainFieldRelationshipDataDetails();
        UploadedFileRelationship referenceRelationship = new UploadedFileRelationship();
        referenceRelationship.artifactId = this.from;
        referenceRelationship.uploadedFileId = stringFieldValue;
        referenceRelationship.relationshipData = fieldRelationshipData;
        this.relationships.add(referenceRelationship);
    }

    @Override
    public void visit(List<Object> listFieldValue) {
        IntStream.range(0, listFieldValue.size()).forEach(i -> {
            Object fieldValue = listFieldValue.get(i);
            ListUploadedFileRelationshipFieldCollector collector = new ListUploadedFileRelationshipFieldCollector(i);
            collector.visit(fieldValue);
            this.relationships.add(collector.relationship);
        });
    }

    private class ListUploadedFileRelationshipFieldCollector
    implements IFieldAndListValueVisitor {
        private final int index;
        public UploadedFileRelationship relationship;

        private ListUploadedFileRelationshipFieldCollector(int index) {
            this.index = index;
        }

        @Override
        public void visit(String stringFieldValue) {
            ListFieldRelationshipDataDetails listFieldRelationshipDataDetails = new ListFieldRelationshipDataDetails();
            listFieldRelationshipDataDetails.index = this.index;
            FieldRelationshipData fieldRelationshipData = new FieldRelationshipData();
            fieldRelationshipData.fieldId = UploadedFilesRelationshipFieldCollector.this.fieldId;
            fieldRelationshipData.details = listFieldRelationshipDataDetails;
            this.relationship = new UploadedFileRelationship();
            this.relationship.artifactId = UploadedFilesRelationshipFieldCollector.this.from;
            this.relationship.uploadedFileId = stringFieldValue;
            this.relationship.relationshipData = fieldRelationshipData;
        }
    }
}

