/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation;

import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceAction;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfiguration;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.validation.IAutomaticConfigurationValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.utils.ValidatorUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutomaticConfigurationValidationService
implements IAutomaticConfigurationValidationService {
    @Autowired
    private IBlueprintVersionDAO blueprintVersionDAO;

    @Override
    public void validateArtifactAutoGovernanceConfiguration(ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration, boolean checkBPVExists) throws IOException {
        if (artifactAutoGovernanceConfiguration instanceof ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration) {
            ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration projectAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)artifactAutoGovernanceConfiguration;
            AutomaticConfigurationValidationService.checkStatusNotPresent(List.of(projectAutoGovernanceConfiguration.bundlesConfig, projectAutoGovernanceConfiguration.modelsConfig, projectAutoGovernanceConfiguration.modelVersionsConfig), AutoGovernanceAction.RUN_SCRIPT, projectAutoGovernanceConfiguration.artifactId);
            this.visit(projectAutoGovernanceConfiguration.bundlesConfig, SystemProvidedConstants.GOVERN_BUNDLE.blueprintId, checkBPVExists);
            this.visit(projectAutoGovernanceConfiguration.modelsConfig, SystemProvidedConstants.GOVERN_MODEL.blueprintId, checkBPVExists);
            this.visit(projectAutoGovernanceConfiguration.modelVersionsConfig, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, checkBPVExists);
        } else if (artifactAutoGovernanceConfiguration instanceof ArtifactAutoGovernanceConfiguration.InstanceAutoGovernanceConfiguration) {
            ArtifactAutoGovernanceConfiguration.InstanceAutoGovernanceConfiguration instanceAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.InstanceAutoGovernanceConfiguration)artifactAutoGovernanceConfiguration;
            AutomaticConfigurationValidationService.checkStatusNotPresent(List.of(instanceAutoGovernanceConfiguration.projectsConfig, instanceAutoGovernanceConfiguration.bundlesConfig, instanceAutoGovernanceConfiguration.modelsConfig, instanceAutoGovernanceConfiguration.modelVersionsConfig), AutoGovernanceAction.INHERIT, instanceAutoGovernanceConfiguration.artifactId);
            this.visit(instanceAutoGovernanceConfiguration.projectsConfig, SystemProvidedConstants.GOVERN_PROJECT.blueprintId, checkBPVExists);
            this.visit(instanceAutoGovernanceConfiguration.bundlesConfig, SystemProvidedConstants.GOVERN_BUNDLE.blueprintId, checkBPVExists);
            this.visit(instanceAutoGovernanceConfiguration.modelsConfig, SystemProvidedConstants.GOVERN_MODEL.blueprintId, checkBPVExists);
            this.visit(instanceAutoGovernanceConfiguration.modelVersionsConfig, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, checkBPVExists);
        } else {
            ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration modelAutoGovernanceConfiguration = (ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)artifactAutoGovernanceConfiguration;
            AutomaticConfigurationValidationService.checkStatusNotPresent(List.of(modelAutoGovernanceConfiguration.modelVersionsConfig), AutoGovernanceAction.RUN_SCRIPT, modelAutoGovernanceConfiguration.artifactId);
            this.visit(modelAutoGovernanceConfiguration.modelVersionsConfig, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, checkBPVExists);
        }
    }

    @Override
    public void validateAutoGovernanceConfigurationBlueprintExists(AutoGovernanceConfiguration autoGovernanceConfiguration) throws IOException {
        ValidatorUtils.validateThat(this.blueprintVersionDAO.exists(autoGovernanceConfiguration.blueprintVersionId), "Blueprint version '%s' does not exists", autoGovernanceConfiguration.blueprintVersionId);
    }

    private static void checkStatusNotPresent(List<AutoGovernanceConfiguration> autogovList, AutoGovernanceAction notAllowed, String ArtifactId) {
        for (AutoGovernanceConfiguration autogov : autogovList) {
            if (autogov.action != notAllowed) continue;
            throw new ValidationException("project configuration for artifact id `" + ArtifactId + "` cannot contain status: " + String.valueOf((Object)notAllowed));
        }
    }

    public void visit(AutoGovernanceConfiguration autoGovernanceConfiguration, String blueprintIdAtLevel, boolean checkBPVExists) throws IOException {
        ValidatorUtils.validateThat(autoGovernanceConfiguration != null, "AutoGovernConfiguration can't be null", new Object[0]);
        ValidatorUtils.validateThat(autoGovernanceConfiguration.action != null, "AutoGovernConfiguration action can't be null", new Object[0]);
        if (autoGovernanceConfiguration.action == AutoGovernanceAction.GOVERN) {
            if (autoGovernanceConfiguration.blueprintVersionId == null || StringUtils.isBlank((String)autoGovernanceConfiguration.blueprintVersionId.blueprintId) || StringUtils.isBlank((String)autoGovernanceConfiguration.blueprintVersionId.versionId)) {
                throw new ValidationException("blueprintVersionId must be provided for an enabled autoGovernanceConfiguration for level: " + blueprintIdAtLevel);
            }
            if (!blueprintIdAtLevel.equals(autoGovernanceConfiguration.blueprintVersionId.blueprintId)) {
                throw new ValidationException("Can't use blueprint version id: " + String.valueOf(autoGovernanceConfiguration.blueprintVersionId) + " as an auto-govern template for level: " + blueprintIdAtLevel);
            }
            if (checkBPVExists) {
                this.validateAutoGovernanceConfigurationBlueprintExists(autoGovernanceConfiguration);
            }
        }
    }
}

