/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.utils;

import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class IdentifiersUtils {
    public static final String SEPARATOR = ".";
    public static final String BLUEPRINT_PREFIX = "bp";
    public static final String BLUEPRINT_VERSION_PREFIX = "bv";
    public static final String ARTIFACT_PREFIX = "ar";
    public static final String UPLOADED_FILE_PREFIX = "uf";
    public static final String ROLE_PREFIX = "ro";
    public static final String TIME_SERIES_PREFIX = "ts";
    public static final String CUSTOM_PAGE_PREFIX = "cp";
    public static final String BLUEPRINT_VERSION_MIGRATION_PATH_PREFIX = "mp";
    public static final String HUMAN_READABLE_ID_REGEXP = "[a-zA-Z0-9-_]+";

    public static String buildBlueprintIdForSystem(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid blueprint ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(BLUEPRINT_PREFIX, ItemSource.SYSTEM.name().toLowerCase(), identifier);
    }

    public static String buildBlueprintIdForPlugin(String pluginId, String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(pluginId)) {
            throw new ValidationException("Invalid plugin ID: " + pluginId);
        }
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid blueprint ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(BLUEPRINT_PREFIX, ItemSource.PLUGIN.name().toLowerCase(), pluginId, identifier);
    }

    public static String buildBlueprintIdForCustom(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid blueprint ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(BLUEPRINT_PREFIX, identifier);
    }

    public static String buildBlueprintVersionIdForSystem(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid blueprint version ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(BLUEPRINT_VERSION_PREFIX, ItemSource.SYSTEM.name().toLowerCase(), identifier);
    }

    public static String buildBlueprintVersionIdForPlugin(String pluginId, String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(pluginId)) {
            throw new ValidationException("Invalid plugin ID: " + pluginId);
        }
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid blueprint version ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(BLUEPRINT_VERSION_PREFIX, ItemSource.PLUGIN.name().toLowerCase(), pluginId, identifier);
    }

    public static String buildBlueprintVersionIdForCustom(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid blueprint version ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(BLUEPRINT_VERSION_PREFIX, identifier);
    }

    public static String buildCustomPageIdForSystem(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid custom page ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(CUSTOM_PAGE_PREFIX, ItemSource.SYSTEM.name().toLowerCase(), identifier);
    }

    public static String buildCustomPageIdForPlugin(String pluginId, String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid plugin ID: " + pluginId);
        }
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid custom page version ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(CUSTOM_PAGE_PREFIX, ItemSource.PLUGIN.name().toLowerCase(), pluginId, identifier);
    }

    public static String buildCustomPageIdForCustom(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid custom page ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(CUSTOM_PAGE_PREFIX, identifier);
    }

    public static String buildMigrationPathId(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid blueprint version migration path ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(BLUEPRINT_VERSION_MIGRATION_PATH_PREFIX, identifier);
    }

    public static boolean isValidBlueprintId(String blueprintId) {
        return IdentifiersUtils.isValidMultiSourceId(blueprintId, BLUEPRINT_PREFIX);
    }

    public static boolean isValidBlueprintVersionId(String blueprintVersionId) {
        return IdentifiersUtils.isValidMultiSourceId(blueprintVersionId, BLUEPRINT_VERSION_PREFIX);
    }

    public static boolean isValidCustomPageId(String customPageId) {
        return IdentifiersUtils.isValidMultiSourceId(customPageId, CUSTOM_PAGE_PREFIX);
    }

    public static boolean isValidBlueprintVersionMigrationPathId(String migrationPathId) {
        return IdentifiersUtils.isValidMultiSourceId(migrationPathId, BLUEPRINT_VERSION_MIGRATION_PATH_PREFIX);
    }

    public static boolean isValidTimeSeriesId(String timeSeriesId) {
        return IdentifiersUtils.isValid2PartsId(TIME_SERIES_PREFIX, timeSeriesId);
    }

    public static boolean isValidHumanReadableId(String identifier) {
        if (identifier == null) {
            return false;
        }
        return identifier.matches(HUMAN_READABLE_ID_REGEXP);
    }

    private static boolean isValidMultiSourceId(String itemId, String prefix) {
        if (StringUtils.isBlank((CharSequence)itemId)) {
            return false;
        }
        String[] elements = StringUtils.split((String)itemId, (String)SEPARATOR);
        if (elements.length < 2 || 4 < elements.length) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)elements[0], (CharSequence)prefix)) {
            return false;
        }
        for (String el : elements) {
            if (IdentifiersUtils.isValidHumanReadableId(el)) continue;
            return false;
        }
        if (elements.length == 2) {
            return true;
        }
        try {
            ItemSource itemSource = ItemSource.valueOf(elements[1].toUpperCase());
            switch (itemSource) {
                case SYSTEM: {
                    return elements.length == 3;
                }
                case PLUGIN: {
                    return elements.length == 4;
                }
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String getIdentifierFromBlueprintId(String blueprintId) {
        if (!IdentifiersUtils.isValidBlueprintId(blueprintId)) {
            throw new ValidationException("Invalid blueprint ID: " + blueprintId);
        }
        String[] elements = StringUtils.split((String)blueprintId, (String)SEPARATOR);
        return elements[elements.length - 1];
    }

    public static String getIdentifierFromBlueprintVersionId(String blueprintVersionId) {
        if (!IdentifiersUtils.isValidBlueprintVersionId(blueprintVersionId)) {
            throw new ValidationException("Invalid blueprint version ID: " + blueprintVersionId);
        }
        String[] elements = StringUtils.split((String)blueprintVersionId, (String)SEPARATOR);
        return elements[elements.length - 1];
    }

    public static ItemSource getSourceFromBlueprintId(String blueprintId) {
        if (!IdentifiersUtils.isValidBlueprintId(blueprintId)) {
            throw new ValidationException("Invalid blueprint ID: " + blueprintId);
        }
        return IdentifiersUtils.getItemSourceFromMultiSourceId(blueprintId);
    }

    public static ItemSource getSourceFromBlueprintVersionId(String blueprintVersionId) {
        if (!IdentifiersUtils.isValidBlueprintVersionId(blueprintVersionId)) {
            throw new ValidationException("Invalid blueprint version ID: " + blueprintVersionId);
        }
        return IdentifiersUtils.getItemSourceFromMultiSourceId(blueprintVersionId);
    }

    public static ItemSource getSourceFromCustomPageId(String customPageId) {
        if (!IdentifiersUtils.isValidCustomPageId(customPageId)) {
            throw new ValidationException("Invalid custom page ID: " + customPageId);
        }
        return IdentifiersUtils.getItemSourceFromMultiSourceId(customPageId);
    }

    public static ItemSource getSourceFromBlueprintVersionMigrationPathId(String blueprintVersionMigrationPathId) {
        if (!IdentifiersUtils.isValidBlueprintVersionMigrationPathId(blueprintVersionMigrationPathId)) {
            throw new ValidationException("Invalid blueprint version migration path ID: " + blueprintVersionMigrationPathId);
        }
        return IdentifiersUtils.getItemSourceFromMultiSourceId(blueprintVersionMigrationPathId);
    }

    private static ItemSource getItemSourceFromMultiSourceId(String itemId) {
        String[] elements = StringUtils.split((String)itemId, (String)SEPARATOR);
        if (elements.length == 2) {
            return ItemSource.CUSTOM;
        }
        String source = elements[1].toUpperCase();
        return ItemSource.valueOf(source);
    }

    public static String buildUploadedFileId(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid uploaded file ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(UPLOADED_FILE_PREFIX, identifier);
    }

    public static String buildTimeSeriesId(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid time series ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(TIME_SERIES_PREFIX, identifier);
    }

    public static String buildArtifactId(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid artifact ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(ARTIFACT_PREFIX, identifier);
    }

    public static boolean isValidArtifactId(String artifactId) {
        return IdentifiersUtils.isValid2PartsId(ARTIFACT_PREFIX, artifactId);
    }

    public static String buildRoleId(String identifier) {
        if (!IdentifiersUtils.isValidHumanReadableId(identifier)) {
            throw new ValidationException("Invalid role ID: " + identifier);
        }
        return IdentifiersUtils.buildMultiPartsId(ROLE_PREFIX, identifier);
    }

    public static boolean isValidRoleId(String roleId) {
        return IdentifiersUtils.isValid2PartsId(ROLE_PREFIX, roleId);
    }

    private static String buildMultiPartsId(String ... parts) {
        return Arrays.stream(parts).collect(Collectors.joining(SEPARATOR));
    }

    private static boolean isValid2PartsId(String expectedPrefix, String prefixedId) {
        if (StringUtils.isBlank((CharSequence)prefixedId)) {
            return false;
        }
        String[] elements = StringUtils.split((String)prefixedId, (String)SEPARATOR);
        if (elements.length != 2) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)elements[0], (CharSequence)expectedPrefix)) {
            return false;
        }
        return IdentifiersUtils.isValidHumanReadableId(elements[1]);
    }

    @UIModel
    public static enum ItemSource {
        SYSTEM,
        PLUGIN,
        CUSTOM;

    }
}

