/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.models.filter;

import com.dataiku.scoring.models.filter.SimpleFilterDesc;
import com.dataiku.scoring.models.filter.SimpleFilterDescChecker;
import com.dataiku.scoring.util.RawObservation;
import java.util.Objects;
import java.util.function.Function;

public class FilterUiConditionChecker {
    private final Function<RawObservation, Boolean> matchesInternal;

    public FilterUiConditionChecker(SimpleFilterDesc.FilterUiCondition condition) {
        this.matchesInternal = this.getMatchesMethod(condition);
    }

    public Boolean matches(RawObservation row) {
        return this.matchesInternal.apply(row);
    }

    private Boolean tryCheckEmptyString(RawObservation row, String colName) {
        Object val = row.get(colName);
        if (val == null) {
            return true;
        }
        try {
            String strVal = (String)val;
            strVal = strVal.trim();
            return strVal.isEmpty();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private Object getDoubleOrString(Object v) {
        if (v instanceof Double) {
            return v;
        }
        try {
            return Double.parseDouble((String)v);
        }
        catch (Exception e) {
            return v;
        }
    }

    private boolean compareEqual(Function<Double, Boolean> comparator) {
        return comparator.apply(0.0);
    }

    private boolean compareDistinct(Function<Double, Boolean> comparator) {
        return comparator.apply(Double.NaN);
    }

    private boolean compareCols(RawObservation row, String col1, String col2, Function<Double, Boolean> comparator) {
        Object val1 = this.getDoubleOrString(row.get(col1));
        Object val2 = this.getDoubleOrString(row.get(col2));
        if (val1 == null && val2 == null) {
            return this.compareEqual(comparator);
        }
        if (val1 == null || val2 == null) {
            return this.compareDistinct(comparator);
        }
        if (val1 instanceof Double && val2 instanceof Double) {
            return comparator.apply((Double)val1 - (Double)val2);
        }
        if (val1 instanceof String && val2 instanceof String) {
            int strDiff = ((String)val1).compareTo((String)val2);
            return comparator.apply(Double.valueOf(strDiff));
        }
        return this.compareDistinct(comparator);
    }

    private Function<RawObservation, Boolean> getMatchesMethod(SimpleFilterDesc.FilterUiCondition condition) {
        if (condition.subCondition != null) {
            return r -> new SimpleFilterDescChecker(condition.subCondition).matches((RawObservation)r);
        }
        SimpleFilterDesc.FilterUiOperator operator = SimpleFilterDesc.FilterUiOperator.fromRepr(condition.operator);
        switch (operator) {
            case NOT_EMPTY: 
            case NOT_EMPTY_STRING: {
                return row -> this.tryCheckEmptyString((RawObservation)row, condition.input) == false;
            }
            case EMPTY: 
            case EMPTY_STRING: {
                return row -> this.tryCheckEmptyString((RawObservation)row, condition.input);
            }
            case EQUALS_STRING: {
                return row -> Objects.equals(row.getAsString(condition.input), condition.string);
            }
            case EQUALS_CASE_INSENSITIVE_STRING: {
                return row -> {
                    String str = row.getAsString(condition.input);
                    return str != null && str.equalsIgnoreCase(condition.string);
                };
            }
            case NOT_EQUALS_STRING: {
                return row -> !Objects.equals(row.getAsString(condition.input), condition.string);
            }
            case CONTAINS_STRING: {
                return row -> {
                    String str = row.getAsString(condition.input);
                    return str != null && str.contains(condition.string);
                };
            }
            case CONTAINS_CASE_INSENSITIVE_STRING: {
                return row -> {
                    String str = row.getAsString(condition.input);
                    return str != null && str.toLowerCase().contains(condition.string.toLowerCase());
                };
            }
            case NOT_CONTAINS_STRING: {
                return row -> {
                    String str = row.getAsString(condition.input);
                    return str == null || !str.contains(condition.string);
                };
            }
            case NOT_CONTAINS_CASE_INSENSITIVE_STRING: {
                return row -> {
                    String str = row.getAsString(condition.input);
                    return str == null || !str.toLowerCase().contains(condition.string.toLowerCase());
                };
            }
            case REGEX: {
                return row -> {
                    String str = row.getAsString(condition.input);
                    return str != null && str.matches(condition.string);
                };
            }
            case SAME: {
                return row -> {
                    String strOther;
                    String strInput = row.getAsString(condition.input);
                    if (strInput == null) {
                        strInput = "";
                    }
                    if ((strOther = row.getAsString(condition.col)) == null) {
                        strOther = "";
                    }
                    return Objects.equals(strInput, strOther);
                };
            }
            case DIFFERENT: {
                return row -> !Objects.equals(row.getAsString(condition.input), row.getAsString(condition.col));
            }
            case EQUALS_NUMBER: {
                return row -> Objects.equals(row.getAsDoubleOrNaN(condition.input), condition.num);
            }
            case NOT_EQUALS_NUMBER: {
                return row -> !Objects.equals(row.getAsDoubleOrNaN(condition.input), condition.num);
            }
            case LESS_NUMBER: {
                return row -> {
                    Double val = row.getAsDoubleOrNaN(condition.input);
                    return val != null && val < condition.num;
                };
            }
            case LESS_OR_EQUAL_NUMBER: {
                return row -> {
                    Double val = row.getAsDoubleOrNaN(condition.input);
                    return val != null && val <= condition.num;
                };
            }
            case GREATER_NUMBER: {
                return row -> {
                    Double val = row.getAsDoubleOrNaN(condition.input);
                    return val != null && val > condition.num;
                };
            }
            case GREATER_OR_EQUAL_NUMBER: {
                return row -> {
                    Double val = row.getAsDoubleOrNaN(condition.input);
                    return val != null && val >= condition.num;
                };
            }
            case BETWEEN_NUMBER: {
                return row -> {
                    Double val = row.getAsDoubleOrNaN(condition.input);
                    return val != null && val >= condition.num && val <= condition.num2;
                };
            }
            case NOT_BETWEEN_NUMBER: {
                return row -> {
                    Double val = row.getAsDoubleOrNaN(condition.input);
                    return val == null || val < condition.num || val > condition.num2;
                };
            }
            case EQUALS_COL: {
                return row -> this.compareCols((RawObservation)row, condition.input, condition.col, diff -> diff == 0.0);
            }
            case NOT_EQUALS_COL: {
                return row -> this.compareCols((RawObservation)row, condition.input, condition.col, diff -> diff != 0.0);
            }
            case LESS_COL: {
                return row -> this.compareCols((RawObservation)row, condition.input, condition.col, diff -> diff < 0.0);
            }
            case LESS_OR_EQUAL_COL: {
                return row -> this.compareCols((RawObservation)row, condition.input, condition.col, diff -> diff <= 0.0);
            }
            case GREATER_COL: {
                return row -> this.compareCols((RawObservation)row, condition.input, condition.col, diff -> diff > 0.0);
            }
            case GREATER_OR_EQUAL_COL: {
                return row -> this.compareCols((RawObservation)row, condition.input, condition.col, diff -> diff >= 0.0);
            }
        }
        throw new UnsupportedOperationException("Operator not supported: " + String.valueOf((Object)operator));
    }
}

