/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.models.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SimpleFilterDesc
implements Serializable {
    public boolean distinct;
    public boolean enabled;
    public FilterUiData uiData;

    public static SimpleFilterDesc andFilter(SimpleFilterDesc ... filters) {
        return SimpleFilterDesc.combineFilter("&&", filters);
    }

    public static SimpleFilterDesc orFilter(SimpleFilterDesc ... filters) {
        return SimpleFilterDesc.combineFilter("||", filters);
    }

    private static SimpleFilterDesc combineFilter(String mode, SimpleFilterDesc ... filters) {
        if (filters.length == 0) {
            return null;
        }
        if (filters.length == 1) {
            return filters[0];
        }
        SimpleFilterDesc filter = new SimpleFilterDesc();
        filter.enabled = true;
        filter.uiData = new FilterUiData();
        filter.uiData.mode = mode;
        for (SimpleFilterDesc subFilter : filters) {
            FilterUiCondition condition = new FilterUiCondition();
            condition.subCondition = subFilter;
            filter.uiData.conditions.add(condition);
        }
        return filter;
    }

    public static class FilterUiData
    implements Serializable {
        public String mode = "&&";
        public List<FilterUiCondition> conditions = new ArrayList<FilterUiCondition>();
    }

    public static class FilterUiCondition
    implements Serializable {
        public String input;
        public String operator;
        public String col;
        public String string;
        public double num;
        public double num2;
        public String date;
        public String time;
        public String date2;
        public String time2;
        public String unit;
        public SimpleFilterDesc subCondition;
    }

    public static enum FilterUiOperator {
        NOT_EMPTY("not empty"),
        EMPTY("is empty"),
        NOT_EMPTY_STRING("not empty string"),
        EMPTY_STRING("empty string"),
        EQUALS_STRING("== [string]"),
        EQUALS_CASE_INSENSITIVE_STRING("== [string]i"),
        NOT_EQUALS_STRING("!= [string]"),
        SAME("== [NaNcolumn]"),
        DIFFERENT("!= [NaNcolumn]"),
        EQUALS_NUMBER("== [number]"),
        NOT_EQUALS_NUMBER("!= [number]"),
        GREATER_NUMBER(">  [number]"),
        LESS_NUMBER("<  [number]"),
        GREATER_OR_EQUAL_NUMBER(">= [number]"),
        LESS_OR_EQUAL_NUMBER("<= [number]"),
        BETWEEN_NUMBER(">< [number]"),
        NOT_BETWEEN_NUMBER("<> [number]"),
        EQUALS_COL("== [column]"),
        NOT_EQUALS_COL("!= [column]"),
        GREATER_COL(">  [column]"),
        LESS_COL("<  [column]"),
        GREATER_OR_EQUAL_COL(">= [column]"),
        LESS_OR_EQUAL_COL("<= [column]"),
        CONTAINS_STRING("contains"),
        CONTAINS_CASE_INSENSITIVE_STRING("contains [string]i"),
        NOT_CONTAINS_STRING("not contains"),
        NOT_CONTAINS_CASE_INSENSITIVE_STRING("not contains [string]i"),
        REGEX("regex");

        private final String repr;

        private FilterUiOperator(String repr) {
            this.repr = repr;
        }

        public static boolean isSupported(String operator) {
            try {
                FilterUiOperator.fromRepr(operator);
            }
            catch (UnsupportedOperationException e) {
                return false;
            }
            return true;
        }

        public static FilterUiOperator fromRepr(String repr) throws UnsupportedOperationException {
            for (FilterUiOperator value : FilterUiOperator.values()) {
                if (!value.repr.equals(repr)) continue;
                return value;
            }
            throw new UnsupportedOperationException("Unknown operator : " + repr);
        }

        public String getRepr() {
            return this.repr;
        }
    }
}

