/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;

public class Binarizer
implements Processor {
    private static final long serialVersionUID = 0L;
    private final String[] columns;
    private final String[] outputColumns;
    private final double[] thresholds;

    public Binarizer(String[] columns, String[] outputColumns, double[] thresholds) {
        this.columns = columns;
        this.outputColumns = outputColumns;
        this.thresholds = thresholds;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public String[] getOutputColumns() {
        return this.outputColumns;
    }

    public double[] getThresholds() {
        return this.thresholds;
    }

    @Override
    public void process(RawObservation data) {
        for (int i = 0; i < this.columns.length; ++i) {
            String col = this.columns[i];
            Object value = data.get(col);
            if (value == null || !(value instanceof Double)) {
                data.setError("Failed to binarize " + col + " due to improper (null or non-numeric) value");
                return;
            }
            if ((Double)data.get(col) > this.thresholds[i]) {
                data.put(this.outputColumns[i], 1.0);
                continue;
            }
            data.put(this.outputColumns[i], 0.0);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("Binarizer(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]).append(">").append(this.thresholds[i]);
            if (i == this.columns.length - 1) continue;
            s.append(" ; ");
        }
        return s.append(")").toString();
    }
}

