/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class CLIParameters {
    private static final String PARAMETER_PREFIX = "--";
    private final Map<String, String> parameters;
    private static final Logger logger = Logger.getLogger("dku.scoring");

    public CLIParameters(String[] args) {
        this.parameters = CLIParameters.parseArguments(args);
    }

    public boolean contains(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public int size() {
        return this.parameters.size();
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public String getValue(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public Double getDoubleValue(String parameterName) {
        String value = this.getValue(parameterName);
        if (value == null) {
            return null;
        }
        return Double.parseDouble(value);
    }

    private static Map<String, String> parseArguments(String[] args) {
        if (args == null || args.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parsedArgs = new HashMap<String, String>();
        String currentParamKey = null;
        for (String arg : args) {
            if (arg.startsWith(PARAMETER_PREFIX)) {
                currentParamKey = arg.substring(PARAMETER_PREFIX.length());
                parsedArgs.put(currentParamKey, "");
                continue;
            }
            if (currentParamKey == null) {
                logger.warning("Ignored unnamed parameter: " + arg);
                continue;
            }
            parsedArgs.put(currentParamKey, arg);
            currentParamKey = null;
        }
        return parsedArgs;
    }
}

