/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.vendor.opencsv;

import com.dataiku.dip.input.formats.CSVParserUtils;
import com.dataiku.dip.input.formats.vendor.opencsv.CSVParser;
import com.dataiku.dip.input.stream.CloseableLineReader;
import com.dataiku.dip.utils.BoundedBufferedLineReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader
implements Closeable {
    private CloseableLineReader br;
    private boolean hasNext = true;
    private CSVParser parser;
    private int skipLines;
    private boolean linesSkiped;
    private Integer maxRowChars;
    private int currentLine = 1;
    public static final int DEFAULT_SKIP_LINES = 0;

    public CSVReader(Reader reader) {
        this(reader, ',', '\"', '\\');
    }

    public CSVReader(Reader reader, char separator) {
        this(reader, separator, '\"', '\\');
    }

    public CSVReader(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, '\\', 0, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, boolean strictQuotes) {
        this(reader, separator, quotechar, '\\', 0, strictQuotes);
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape) {
        this(reader, separator, quotechar, escape, 0, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, int line) {
        this(reader, separator, quotechar, '\\', line, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line) {
        this(reader, separator, quotechar, escape, line, false);
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes) {
        this(reader, separator, quotechar, escape, line, strictQuotes, true);
    }

    public CSVReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(reader, Character.valueOf(separator), Character.valueOf(quotechar), Character.valueOf(escape), line, strictQuotes, ignoreLeadingWhiteSpace, null);
    }

    public CSVReader(Reader reader, Character separator, Character quotechar, Character escape, Integer line, Boolean strictQuotes, Boolean ignoreLeadingWhiteSpace, Integer maxRowChars) {
        this.br = new BoundedBufferedLineReader(reader, maxRowChars);
        if (separator == null) {
            separator = Character.valueOf(',');
        }
        if (quotechar == null) {
            quotechar = Character.valueOf('\"');
        }
        if (escape == null) {
            escape = Character.valueOf('\\');
        }
        if (line == null) {
            line = 0;
        }
        if (strictQuotes == null) {
            strictQuotes = false;
        }
        if (ignoreLeadingWhiteSpace == null) {
            ignoreLeadingWhiteSpace = true;
        }
        this.parser = new CSVParser(separator.charValue(), quotechar.charValue(), escape.charValue(), strictQuotes, ignoreLeadingWhiteSpace);
        this.skipLines = line;
        this.maxRowChars = maxRowChars;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        String[] result = null;
        int currentRowChars = 0;
        do {
            String nextLine = this.getNextLine();
            if (!this.hasNext) {
                return result;
            }
            String[] r = this.parser.parseLineMulti(nextLine);
            if (r.length > 0) {
                if (result == null) {
                    result = r;
                } else {
                    String[] t = new String[result.length + r.length];
                    System.arraycopy(result, 0, t, 0, result.length);
                    System.arraycopy(r, 0, t, result.length, r.length);
                    result = t;
                }
            }
            CSVParserUtils.checkRowLength(currentRowChars += nextLine.length() + 1, this.maxRowChars, this.currentLine);
        } while (this.parser.isPending());
        ++this.currentLine;
        return result;
    }

    private String getNextLine() throws IOException {
        String nextLine;
        if (!this.linesSkiped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.br.readLine();
            }
            this.linesSkiped = true;
        }
        if ((nextLine = this.br.readLine()) == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }
}

