/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DeleteFleetsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DeleteFleetsRequestMarshaller
implements Marshaller<Request<DeleteFleetsRequest>, DeleteFleetsRequest> {
    @Override
    public Request<DeleteFleetsRequest> marshall(DeleteFleetsRequest deleteFleetsRequest) {
        if (deleteFleetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteFleetsRequest> request = new DefaultRequest<DeleteFleetsRequest>(deleteFleetsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteFleets");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList deleteFleetsRequestFleetIdsList = (SdkInternalList)deleteFleetsRequest.getFleetIds();
        if (!deleteFleetsRequestFleetIdsList.isEmpty() || !deleteFleetsRequestFleetIdsList.isAutoConstruct()) {
            int fleetIdsListIndex = 1;
            for (String deleteFleetsRequestFleetIdsListValue : deleteFleetsRequestFleetIdsList) {
                if (deleteFleetsRequestFleetIdsListValue != null) {
                    request.addParameter("FleetId." + fleetIdsListIndex, StringUtils.fromString(deleteFleetsRequestFleetIdsListValue));
                }
                ++fleetIdsListIndex;
            }
        }
        if (deleteFleetsRequest.getTerminateInstances() != null) {
            request.addParameter("TerminateInstances", StringUtils.fromBoolean(deleteFleetsRequest.getTerminateInstances()));
        }
        return request;
    }
}

