/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ResourceStatement;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.StaxUnmarshallerContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ResourceStatementStaxUnmarshaller
implements Unmarshaller<ResourceStatement, StaxUnmarshallerContext> {
    private static ResourceStatementStaxUnmarshaller instance;

    @Override
    public ResourceStatement unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceStatement resourceStatement = new ResourceStatement();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceStatement;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("resourceSet", targetDepth)) {
                    resourceStatement.withResources(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("resourceSet/item", targetDepth)) {
                    resourceStatement.withResources(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("resourceTypeSet", targetDepth)) {
                    resourceStatement.withResourceTypes(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("resourceTypeSet/item", targetDepth)) continue;
                resourceStatement.withResourceTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceStatement;
    }

    public static ResourceStatementStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceStatementStaxUnmarshaller();
        }
        return instance;
    }
}

