/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.GlueSchema;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.SnowflakeNodeData;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform.SnowflakeSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SnowflakeSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private SnowflakeNodeData data;
    private List<GlueSchema> outputSchemas;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SnowflakeSource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setData(SnowflakeNodeData data) {
        this.data = data;
    }

    public SnowflakeNodeData getData() {
        return this.data;
    }

    public SnowflakeSource withData(SnowflakeNodeData data) {
        this.setData(data);
        return this;
    }

    public List<GlueSchema> getOutputSchemas() {
        return this.outputSchemas;
    }

    public void setOutputSchemas(Collection<GlueSchema> outputSchemas) {
        if (outputSchemas == null) {
            this.outputSchemas = null;
            return;
        }
        this.outputSchemas = new ArrayList<GlueSchema>(outputSchemas);
    }

    public SnowflakeSource withOutputSchemas(GlueSchema ... outputSchemas) {
        if (this.outputSchemas == null) {
            this.setOutputSchemas(new ArrayList<GlueSchema>(outputSchemas.length));
        }
        for (GlueSchema ele : outputSchemas) {
            this.outputSchemas.add(ele);
        }
        return this;
    }

    public SnowflakeSource withOutputSchemas(Collection<GlueSchema> outputSchemas) {
        this.setOutputSchemas(outputSchemas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getData() != null) {
            sb.append("Data: ").append(this.getData()).append(",");
        }
        if (this.getOutputSchemas() != null) {
            sb.append("OutputSchemas: ").append(this.getOutputSchemas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeSource)) {
            return false;
        }
        SnowflakeSource other = (SnowflakeSource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        if (other.getData() != null && !other.getData().equals(this.getData())) {
            return false;
        }
        if (other.getOutputSchemas() == null ^ this.getOutputSchemas() == null) {
            return false;
        }
        return other.getOutputSchemas() == null || other.getOutputSchemas().equals(this.getOutputSchemas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSchemas() == null ? 0 : this.getOutputSchemas().hashCode());
        return hashCode;
    }

    public SnowflakeSource clone() {
        try {
            return (SnowflakeSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnowflakeSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

