/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.dataiku.dip.DSSMetrics;

public class APINodeMetrics {
    public static Counter serviceCounter(String serviceId, String metric) {
        return DSSMetrics.registry().counter("dku.lambda.service." + serviceId + "." + metric);
    }

    public static Meter serviceMeter(String serviceId, String metric) {
        return DSSMetrics.registry().meter("dku.lambda.service." + serviceId + "." + metric);
    }

    private static String forEndpoint(String serviceId, String endpointId, String metric) {
        return "dku.lambda.service." + serviceId + "." + endpointId + "." + metric;
    }

    public static Timer endpointTimer(String serviceId, String endpointId, String metric) {
        return DSSMetrics.registry().timer(APINodeMetrics.forEndpoint(serviceId, endpointId, metric));
    }

    public static DSSMetrics.TimeCtx endpointTimeCtx(String serviceId, String endpointId, String metric) {
        return DSSMetrics.timeCtx((Timer)APINodeMetrics.endpointTimer(serviceId, endpointId, metric));
    }

    public static Meter endpointMeter(String serviceId, String endpointId, String metric) {
        return DSSMetrics.registry().meter(APINodeMetrics.forEndpoint(serviceId, endpointId, metric));
    }

    public static Counter endpointCounter(String serviceId, String endpointId, String metric) {
        return DSSMetrics.registry().counter(APINodeMetrics.forEndpoint(serviceId, endpointId, metric));
    }
}

