/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.services;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.json.HealthCheckModule;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class AliveService {
    @Autowired
    private LambdaContext context;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.apinode.alive");

    public synchronized void setNotAlive() throws IOException {
        logger.info((Object)"Setting node as not-alive");
        DKUFileUtils.createIfNotExists((File)this.context.getFile(new String[]{"apinode-not-alive.txt"}));
    }

    public synchronized void setAlive() throws IOException {
        logger.info((Object)"Setting node as alive");
        File f = this.context.getFile(new String[]{"apinode-not-alive.txt"});
        if (f.isFile()) {
            DKUFileUtils.forceDelete((File)f);
        }
    }

    public synchronized JsonObject isAlive(@Nonnull JsonObject ret) {
        boolean forcedNotAlive = this.context.getFile(new String[]{"apinode-not-alive.txt"}).isFile();
        if (forcedNotAlive) {
            ret.addProperty("forcedNotAlive", Boolean.valueOf(true));
            ret.addProperty("alive", Boolean.valueOf(false));
        } else {
            JsonObject hc = new JsonObject();
            ret.addProperty("alive", Boolean.valueOf(true));
            ObjectMapper om = new ObjectMapper().registerModule((Module)new HealthCheckModule());
            for (Map.Entry e : this.context.getHealthChecks().runHealthChecks().entrySet()) {
                StringWriter sw = new StringWriter();
                try {
                    om.writerWithDefaultPrettyPrinter().writeValue((Writer)sw, e.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hc.add((String)e.getKey(), (JsonElement)JSON.parse((String)sw.toString(), JsonObject.class));
                if (((HealthCheck.Result)e.getValue()).isHealthy()) continue;
                ret.addProperty("alive", Boolean.valueOf(false));
            }
            ret.add("healthChecks", (JsonElement)hc);
        }
        return ret;
    }
}

