/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.SecurityManager;
import net.snowflake.ingest.internal.apache.http.client.methods.HttpGet;
import net.snowflake.ingest.internal.apache.http.client.methods.HttpPost;
import net.snowflake.ingest.internal.apache.http.client.methods.HttpUriRequest;
import net.snowflake.ingest.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.ingest.internal.apache.http.entity.ContentType;
import net.snowflake.ingest.internal.apache.http.entity.StringEntity;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.ingest.utils.StagedFileWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RequestBuilder.class.getName());
    private SecurityManager securityManager;
    private String scheme;
    private final int port;
    private final String host;
    private final String userAgentSuffix;
    public static final String DEFAULT_HOST_SUFFIX = "snowflakecomputing.com";
    private static final String DEFAULT_SCHEME = "https";
    private static final int DEFAULT_PORT = 443;
    private static final String INGEST_ENDPOINT_FORMAT = "/v1/data/pipes/%s/insertFiles";
    private static final String HISTORY_ENDPOINT_FORMAT = "/v1/data/pipes/%s/insertReport";
    private static final String HISTORY_RANGE_ENDPOINT_FORMAT = "/v1/data/pipes/%s/loadHistoryScan";
    private static final String RECENT_HISTORY_IN_SECONDS = "recentSeconds";
    private static final String HISTORY_BEGIN_MARK = "beginMark";
    private static final String HISTORY_RANGE_START_INCLUSIVE = "startTimeInclusive";
    private static final String HISTORY_RANGE_END_EXCLUSIVE = "endTimeExclusive";
    private static final String REQUEST_ID = "requestId";
    private static final String SHOW_SKIPPED_FILES = "showSkippedFiles";
    private static final String BEARER_PARAMETER = "Bearer ";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String RESOURCES_FILE = "project.properties";
    private static final Properties PROPERTIES = RequestBuilder.loadProperties();
    private static final String USER_AGENT = RequestBuilder.getDefaultUserAgent();
    public static final String CLIENT_NAME = "SnowpipeJavaSDK";
    public static final String DEFAULT_VERSION = "0.10.3";
    public static final String JAVA_USER_AGENT = "JAVA";
    public static final String OS_INFO_USER_AGENT_FORMAT = "(%s %s %s)";

    public RequestBuilder(String accountName, String userName, KeyPair keyPair) {
        this(accountName, userName, keyPair, DEFAULT_SCHEME, DEFAULT_HOST_SUFFIX, 443, null);
    }

    public RequestBuilder(String accountName, String userName, String hostName, KeyPair keyPair, String userAgentSuffix) {
        this(accountName, userName, keyPair, DEFAULT_SCHEME, hostName, 443, userAgentSuffix);
    }

    public RequestBuilder(String accountName, String userName, KeyPair keyPair, String schemeName, String hostName, int portNum) {
        this(accountName, userName, keyPair, schemeName, hostName, portNum, null);
    }

    public RequestBuilder(String accountName, String userName, KeyPair keyPair, String schemeName, String hostName, int portNum, String userAgentSuffix) {
        if (accountName == null || userName == null || keyPair == null) {
            throw new IllegalArgumentException();
        }
        this.securityManager = new SecurityManager(accountName, userName, keyPair);
        String account = accountName.toUpperCase();
        String user = userName.toUpperCase();
        this.port = portNum;
        this.scheme = schemeName;
        this.host = hostName;
        this.userAgentSuffix = userAgentSuffix;
        LOGGER.info("Creating a RequestBuilder with arguments : Account : {}, User : {}, Scheme : {}, Host : {}, Port : {}, userAgentSuffix: {}", new Object[]{account, user, this.scheme, this.host, this.port, this.userAgentSuffix});
    }

    private static Properties loadProperties() {
        Properties properties = new Properties();
        properties.put("version", DEFAULT_VERSION);
        try {
            URI uri;
            URL res = SimpleIngestManager.class.getClassLoader().getResource(RESOURCES_FILE);
            if (res == null) {
                throw new UncheckedIOException(new FileNotFoundException(RESOURCES_FILE));
            }
            try {
                uri = res.toURI();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
            try (InputStream is = Files.newInputStream(Paths.get(uri), new OpenOption[0]);){
                properties.load(is);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to load resource", ex);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not read version info: " + e.toString());
        }
        return properties;
    }

    private static String getDefaultUserAgent() {
        String clientVersion = PROPERTIES.getProperty("version");
        StringBuilder defaultUserAgent = new StringBuilder("SnowpipeJavaSDK/" + clientVersion);
        String osInformation = String.format(OS_INFO_USER_AGENT_FORMAT, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        defaultUserAgent.append(" ");
        defaultUserAgent.append(osInformation);
        defaultUserAgent.append(" ");
        String javaVersion = System.getProperty("java.version");
        defaultUserAgent.append("JAVA/" + javaVersion);
        return defaultUserAgent.toString();
    }

    private static String buildCustomUserAgent(String additionalUserAgentInfo) {
        return USER_AGENT.trim() + " " + additionalUserAgentInfo;
    }

    private URIBuilder makeBaseURI(UUID requestId) {
        if (requestId == null) {
            LOGGER.error("RequestId is null!");
            throw new IllegalArgumentException();
        }
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.scheme);
        builder.setHost(this.host);
        builder.setPort(this.port);
        builder.setParameter(REQUEST_ID, requestId.toString());
        return builder;
    }

    private URI makeInsertURI(UUID requestId, String pipe, boolean showSkippedFiles) throws URISyntaxException {
        if (pipe == null) {
            LOGGER.error("Table argument is null");
            throw new IllegalArgumentException();
        }
        URIBuilder builder = this.makeBaseURI(requestId);
        builder.setParameter(SHOW_SKIPPED_FILES, String.valueOf(showSkippedFiles));
        builder.setPath(String.format(INGEST_ENDPOINT_FORMAT, pipe));
        return builder.build();
    }

    private URI makeHistoryURI(UUID requestId, String pipe, Integer recentSeconds, String beginMark) throws URISyntaxException {
        if (pipe == null) {
            throw new IllegalArgumentException();
        }
        URIBuilder builder = this.makeBaseURI(requestId);
        builder.setPath(String.format(HISTORY_ENDPOINT_FORMAT, pipe));
        if (recentSeconds != null) {
            builder.setParameter(RECENT_HISTORY_IN_SECONDS, String.valueOf(recentSeconds));
        }
        if (beginMark != null) {
            builder.setParameter(HISTORY_BEGIN_MARK, beginMark);
        }
        LOGGER.info("Final History URIBuilder - {}", (Object)builder.toString());
        return builder.build();
    }

    private URI makeHistoryRangeURI(UUID requestId, String pipe, String startTimeInclusive, String endTimeExclusive) throws URISyntaxException {
        if (pipe == null) {
            throw new IllegalArgumentException();
        }
        URIBuilder builder = this.makeBaseURI(requestId);
        builder.setPath(String.format(HISTORY_RANGE_ENDPOINT_FORMAT, pipe));
        if (startTimeInclusive != null) {
            builder.setParameter(HISTORY_RANGE_START_INCLUSIVE, startTimeInclusive);
        }
        if (endTimeExclusive != null) {
            builder.setParameter(HISTORY_RANGE_END_EXCLUSIVE, endTimeExclusive);
        }
        LOGGER.info("Final History URIBuilder - {}", (Object)builder.toString());
        return builder.build();
    }

    private String generateFilesJSON(List<StagedFileWrapper> files) {
        if (files == null) {
            LOGGER.info("Null files argument in RequestBuilder");
            throw new IllegalArgumentException();
        }
        IngestRequest pojo = new IngestRequest();
        pojo.files = files;
        try {
            return objectMapper.writeValueAsString(pojo);
        }
        catch (Exception e) {
            LOGGER.error("Unable to Generate JSON Body for Insert request");
            throw new RuntimeException();
        }
    }

    private static void addUserAgent(HttpUriRequest request, String userAgentSuffix) {
        if (!Strings.isNullOrEmpty(userAgentSuffix)) {
            String userAgent = RequestBuilder.buildCustomUserAgent(userAgentSuffix);
            request.setHeader("User-Agent", userAgent);
            return;
        }
        request.setHeader("User-Agent", USER_AGENT);
    }

    private static void addToken(HttpUriRequest request, String token) {
        request.setHeader("Authorization", BEARER_PARAMETER + token);
    }

    private static void addHeaders(HttpUriRequest request, String token, String userAgentSuffix) {
        RequestBuilder.addUserAgent(request, userAgentSuffix);
        RequestBuilder.addToken(request, token);
    }

    public HttpPost generateInsertRequest(UUID requestId, String pipe, List<StagedFileWrapper> files, boolean showSkippedFiles) throws URISyntaxException {
        URI insertURI = this.makeInsertURI(requestId, pipe, showSkippedFiles);
        LOGGER.info("Created Insert Request : {} ", (Object)insertURI);
        HttpPost post = new HttpPost(insertURI);
        RequestBuilder.addHeaders(post, this.securityManager.getToken(), this.userAgentSuffix);
        StringEntity entity = new StringEntity(this.generateFilesJSON(files), ContentType.APPLICATION_JSON);
        post.setEntity(entity);
        return post;
    }

    public HttpGet generateHistoryRequest(UUID requestId, String pipe, Integer recentSeconds, String beginMark) throws URISyntaxException {
        URI historyURI = this.makeHistoryURI(requestId, pipe, recentSeconds, beginMark);
        HttpGet get = new HttpGet(historyURI);
        RequestBuilder.addHeaders(get, this.securityManager.getToken(), this.userAgentSuffix);
        return get;
    }

    public HttpGet generateHistoryRangeRequest(UUID requestId, String pipe, String startTimeInclusive, String endTimeExclusive) throws URISyntaxException {
        URI historyRangeURI = this.makeHistoryRangeURI(requestId, pipe, startTimeInclusive, endTimeExclusive);
        HttpGet get = new HttpGet(historyRangeURI);
        RequestBuilder.addHeaders(get, this.securityManager.getToken(), this.userAgentSuffix);
        return get;
    }

    public void closeResources() {
        this.securityManager.close();
    }

    private static class IngestRequest {
        public List<StagedFileWrapper> files;

        private IngestRequest() {
        }
    }
}

