/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.data.currency.CurrencyData;
import com.dataiku.dip.data.currency.CurrencyDataLoader;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import java.io.File;

public class CurrencyConverterAlgorithm {
    private static CurrencyConverterAlgorithm instance;
    private CurrencyDataLoader.CurrenciesData currenciesData;

    public static synchronized CurrencyConverterAlgorithm getInstance(File resourceFile) {
        if (instance == null) {
            instance = new CurrencyConverterAlgorithm(resourceFile);
        }
        return instance;
    }

    private CurrencyConverterAlgorithm(File resourceFile) {
        this.currenciesData = CurrencyDataLoader.load(resourceFile);
    }

    public CurrencyDataLoader.CurrenciesData getCurrenciesData() {
        return this.currenciesData;
    }

    private double getRate(String currencyFrom, String currencyTo, String date) {
        CurrencyData currencyData = this.currenciesData.getCurrency(date);
        if (currencyData == null) {
            return Double.MAX_VALUE;
        }
        return currencyData.getRate(currencyFrom, currencyTo);
    }

    public Double convert(String value, String currencyFrom, String currencyTo, String date, Integer decimalNumber) {
        if (value == null || currencyFrom == null) {
            return null;
        }
        double rate = this.getRate(currencyFrom, currencyTo, date = date != null ? date : "lastKnownDate");
        if (rate == Double.MAX_VALUE) {
            return null;
        }
        Double result = new DoubleMeaning().doubleValue(value) * rate;
        return (double)Math.round(result * Math.pow(10.0, decimalNumber.intValue())) / Math.pow(10.0, decimalNumber.intValue());
    }
}

