/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.data.currency.CurrencyCodes;
import com.dataiku.dip.shaker.types.AbstractAnumMeaning;
import java.util.HashMap;
import java.util.Map;

public class CurrencyMeaning
extends AbstractAnumMeaning {
    private static Map<String, ValidCurrency> data = new HashMap<String, ValidCurrency>();

    public String parse(String v) {
        if (v == null) {
            throw new NumberFormatException("Invalid currency data ");
        }
        ValidCurrency vc = data.get(v.toLowerCase());
        if (vc == null) {
            throw new NumberFormatException("Invalid currency data " + v);
        }
        return vc.val;
    }

    @Override
    public double detects(String v) {
        if (v == null || v.isEmpty()) {
            return 0.0;
        }
        ValidCurrency vc = data.get(v.toLowerCase());
        if (vc == null) {
            return 0.0;
        }
        return vc.score;
    }

    static {
        for (String currency : CurrencyCodes.getAvailableCurrencies()) {
            data.put(currency.toLowerCase(), new ValidCurrency(currency, 0.7));
        }
    }

    static class ValidCurrency {
        String val;
        double score;

        ValidCurrency(String val, double score) {
            this.val = val;
            this.score = score;
        }
    }
}

