/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.shaker.types.AbstractDoubleMeaning;

public class DoubleMeaning
extends AbstractDoubleMeaning {
    @Override
    public double doubleValue(String val) {
        try {
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    @Override
    public double detects(String v) {
        if (v == null) {
            return 0.0;
        }
        boolean foundDigit = false;
        for (int i = 0; i < v.length(); ++i) {
            if (!Character.isDigit(v.charAt(i))) continue;
            foundDigit = true;
            break;
        }
        if (!foundDigit) {
            if ("NaN".equals(v) || "Infinity".equals(v) || "-Infinity".equals(v)) {
                return 0.25;
            }
            return 0.0;
        }
        if (DKUDoubles.isWellFormattedDouble((String)v)) {
            return 0.25;
        }
        return 0.0;
    }
}

