/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractDoubleMeaning;
import com.dataiku.dip.utils.FastSafePatternMatcher;
import java.util.regex.Pattern;

public class Latitude
extends AbstractDoubleMeaning {
    private static final Pattern REMOVE_END = Pattern.compile("\u00b0?[NS]?$");
    private static final FastSafePatternMatcher FAST_LATITUDE_MATCHER = new FastSafePatternMatcher("[\\x00-\\x20]*[+-]?(((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))))[\\x00-\\x20]*[\u00b0]?[NS]?");
    private static final FastSafePatternMatcher INT_MILLI_MATCHER = new FastSafePatternMatcher("[\\x00-\\x20]*[+-]([0-9]{5})");

    public static double convert(String s) {
        double d;
        if (INT_MILLI_MATCHER.matches(s)) {
            int n = Integer.parseInt(s.trim());
            double out = (double)n / 1000.0;
            if (out <= 90.0 && out >= -90.0) {
                return out;
            }
        } else if (FAST_LATITUDE_MATCHER.matches(s) && (d = Double.parseDouble(REMOVE_END.matcher(s).replaceAll("").trim())) >= -90.0 && d <= 90.0) {
            boolean negative = s.endsWith("S");
            return negative ? -d : d;
        }
        return Double.NaN;
    }

    @Override
    public double detects(String s) {
        if (s == null) {
            return 0.0;
        }
        if (INT_MILLI_MATCHER.matches(s)) {
            int n = Integer.parseInt(s.trim());
            double out = (double)n / 1000.0;
            if (out <= 90.0 && out >= -90.0) {
                return 0.6;
            }
        } else if (FAST_LATITUDE_MATCHER.matches(s)) {
            try {
                double d = Double.parseDouble(REMOVE_END.matcher(s).replaceAll("").trim());
                if (d >= -90.0 && d <= 90.0) {
                    if (s.contains("N") || s.contains("S")) {
                        return 0.9;
                    }
                    if (s.contains("\u00b0")) {
                        return 0.6;
                    }
                    if (s.contains(".")) {
                        return 0.15;
                    }
                    return 0.01;
                }
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public double doubleValue(String v) {
        if (v == null) {
            return Double.NaN;
        }
        return Latitude.convert(v);
    }
}

