/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

import com.mongodb.client.model.changestream.TruncatedArray;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class UpdateDescription {
    private final List<String> removedFields;
    private final BsonDocument updatedFields;
    private final List<TruncatedArray> truncatedArrays;
    private final BsonDocument disambiguatedPaths;

    public UpdateDescription(@Nullable List<String> removedFields, @Nullable BsonDocument updatedFields) {
        this(removedFields, updatedFields, null);
    }

    public UpdateDescription(@Nullable List<String> removedFields, @Nullable BsonDocument updatedFields, @Nullable List<TruncatedArray> truncatedArrays) {
        this(removedFields, updatedFields, truncatedArrays, null);
    }

    @BsonCreator
    public UpdateDescription(@Nullable @BsonProperty(value="removedFields") List<String> removedFields, @Nullable @BsonProperty(value="updatedFields") BsonDocument updatedFields, @Nullable @BsonProperty(value="truncatedArrays") List<TruncatedArray> truncatedArrays, @Nullable @BsonProperty(value="disambiguatedPaths") BsonDocument disambiguatedPaths) {
        this.removedFields = removedFields;
        this.updatedFields = updatedFields;
        this.truncatedArrays = truncatedArrays == null ? Collections.emptyList() : truncatedArrays;
        this.disambiguatedPaths = disambiguatedPaths;
    }

    @Nullable
    public List<String> getRemovedFields() {
        return this.removedFields;
    }

    @Nullable
    public BsonDocument getUpdatedFields() {
        return this.updatedFields;
    }

    @NonNull
    public List<TruncatedArray> getTruncatedArrays() {
        return this.truncatedArrays;
    }

    @Nullable
    public BsonDocument getDisambiguatedPaths() {
        return this.disambiguatedPaths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDescription that = (UpdateDescription)o;
        return Objects.equals(this.removedFields, that.removedFields) && Objects.equals(this.updatedFields, that.updatedFields) && Objects.equals(this.truncatedArrays, that.truncatedArrays) && Objects.equals(this.disambiguatedPaths, that.disambiguatedPaths);
    }

    public int hashCode() {
        return Objects.hash(this.removedFields, this.updatedFields, this.truncatedArrays, this.disambiguatedPaths);
    }

    public String toString() {
        return "UpdateDescription{removedFields=" + this.removedFields + ", updatedFields=" + this.updatedFields + ", truncatedArrays=" + this.truncatedArrays + ", disambiguatedPaths=" + this.disambiguatedPaths + "}";
    }
}

