/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.datatable;

import be.quodlibet.boxable.BaseTable;
import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.Table;
import be.quodlibet.boxable.VerticalAlignment;
import be.quodlibet.boxable.line.LineStyle;
import be.quodlibet.boxable.utils.FontUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class DataTable {
    public static final Boolean HASHEADER = true;
    public static final Boolean NOHEADER = false;
    private Table table;
    private final Cell headerCellTemplate;
    private final Cell dataCellTemplateEven;
    private final Cell dataCellTemplateOdd;
    private final Cell firstColumnCellTemplate;
    private final Cell lastColumnCellTemplate;
    private final Cell defaultCellTemplate;

    public DataTable(Table table, PDPage page) throws IOException {
        this.table = table;
        PDDocument ddoc = new PDDocument();
        PDPage dpage = new PDPage();
        dpage.setMediaBox(page.getMediaBox());
        dpage.setRotation(page.getRotation());
        ddoc.addPage(dpage);
        BaseTable dummyTable = new BaseTable(10.0f, 10.0f, 10.0f, table.getWidth(), 10.0f, ddoc, dpage, false, false);
        Row dr = dummyTable.createRow(0.0f);
        this.headerCellTemplate = dr.createCell(10.0f, "A", HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE);
        this.dataCellTemplateEven = dr.createCell(10.0f, "A", HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
        this.dataCellTemplateOdd = dr.createCell(10.0f, "A", HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
        this.firstColumnCellTemplate = dr.createCell(10.0f, "A", HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
        this.lastColumnCellTemplate = dr.createCell(10.0f, "A", HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
        this.defaultCellTemplate = dr.createCell(10.0f, "A", HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
        this.setDefaultStyles();
        ddoc.close();
    }

    private void setDefaultStyles() {
        LineStyle thinline = new LineStyle(Color.BLACK, 0.75f);
        this.headerCellTemplate.setFillColor(new Color(137, 218, 245));
        this.headerCellTemplate.setTextColor(Color.BLACK);
        this.headerCellTemplate.setFont((PDFont)PDType1Font.HELVETICA_BOLD);
        this.headerCellTemplate.setBorderStyle(thinline);
        this.defaultCellTemplate.setFillColor(new Color(242, 242, 242));
        this.defaultCellTemplate.setTextColor(Color.BLACK);
        this.defaultCellTemplate.setFont((PDFont)PDType1Font.HELVETICA);
        this.defaultCellTemplate.setBorderStyle(thinline);
        this.dataCellTemplateEven.copyCellStyle(this.defaultCellTemplate);
        this.dataCellTemplateOdd.copyCellStyle(this.defaultCellTemplate);
        this.firstColumnCellTemplate.copyCellStyle(this.defaultCellTemplate);
        this.lastColumnCellTemplate.copyCellStyle(this.defaultCellTemplate);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Cell getHeaderCellTemplate() {
        return this.headerCellTemplate;
    }

    public Cell getDataCellTemplateEven() {
        return this.dataCellTemplateEven;
    }

    public Cell getDataCellTemplateOdd() {
        return this.dataCellTemplateOdd;
    }

    public Cell getFirstColumnCellTemplate() {
        return this.firstColumnCellTemplate;
    }

    public Cell getLastColumnCellTemplate() {
        return this.lastColumnCellTemplate;
    }

    public void addListToTable(List<List> data, Boolean hasHeader) throws IOException {
        char separator = ';';
        if (data == null || data.isEmpty()) {
            return;
        }
        String output = "";
        for (List inputList : data) {
            for (Object v : inputList) {
                String value = v.toString();
                if (value.contains("" + separator)) {
                    value = "\"" + value + "\"";
                }
                output = output + value + separator;
            }
            output = DataTable.removeLastChar(output);
            output = output + "\n";
        }
        this.addCsvToTable(output, hasHeader, separator);
    }

    private static String removeLastChar(String str) {
        return str.substring(0, str.length() - 1);
    }

    public void addCsvToTable(String data, Boolean hasHeader, char separator) throws IOException {
        CSVParser records = CSVParser.parse((String)data, (CSVFormat)CSVFormat.EXCEL.withDelimiter(separator));
        Boolean isHeader = hasHeader;
        Boolean isFirst = true;
        Boolean odd = true;
        HashMap<Integer, Float> colWidths = new HashMap<Integer, Float>();
        int numcols = 0;
        for (CSVRecord line : records) {
            int i;
            if (isFirst.booleanValue()) {
                float totalWidth = 0.0f;
                i = 0;
                while (i < line.size()) {
                    String cellValue = line.get(i);
                    float textWidth = FontUtils.getStringWidth(this.headerCellTemplate.getFont(), " " + cellValue + " ", this.headerCellTemplate.getFontSize());
                    float widthPct = textWidth * 100.0f / this.table.getWidth();
                    totalWidth += textWidth;
                    numcols = i++;
                }
                float sizefactor = this.table.getWidth() / totalWidth;
                for (int i2 = 0; i2 <= numcols; ++i2) {
                    String cellValue = "";
                    if (line.size() >= i2) {
                        cellValue = line.get(i2);
                    }
                    float textWidth = FontUtils.getStringWidth(this.headerCellTemplate.getFont(), " " + cellValue + " ", this.headerCellTemplate.getFontSize());
                    float widthPct = textWidth * 100.0f / this.table.getWidth();
                    colWidths.put(i2, Float.valueOf(widthPct *= sizefactor));
                }
                isFirst = false;
            }
            if (isHeader.booleanValue()) {
                Row h = this.table.createRow(this.headerCellTemplate.getCellHeight());
                for (i = 0; i <= numcols; ++i) {
                    String cellValue = line.get(i);
                    Cell c = h.createCell(((Float)colWidths.get(i)).floatValue(), cellValue, this.headerCellTemplate.getAlign(), this.headerCellTemplate.getValign());
                    c.copyCellStyle(this.headerCellTemplate);
                    c.setText(cellValue);
                }
                this.table.addHeaderRow(h);
                isHeader = false;
            } else {
                Row r = this.table.createRow(this.dataCellTemplateEven.getCellHeight());
                for (i = 0; i <= numcols; ++i) {
                    Cell template = this.dataCellTemplateEven;
                    if (odd.booleanValue()) {
                        template = this.dataCellTemplateOdd;
                    }
                    if (i == 0 & this.firstColumnCellTemplate.hasSameStyle(this.defaultCellTemplate) == false) {
                        template = this.firstColumnCellTemplate;
                    }
                    if (i == numcols & this.lastColumnCellTemplate.hasSameStyle(this.defaultCellTemplate) == false) {
                        template = this.lastColumnCellTemplate;
                    }
                    String cellValue = "";
                    if (line.size() >= i) {
                        cellValue = line.get(i);
                    }
                    Cell c = r.createCell(((Float)colWidths.get(i)).floatValue(), cellValue, template.getAlign(), template.getValign());
                    c.copyCellStyle(template);
                    c.setText(cellValue);
                }
            }
            odd = odd == false;
        }
    }
}

