/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultDecimalVector;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnReaders;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class DecimalColumnReader {
    public static Converter createDecimalConverter(int n, DecimalType decimalType, Type type) {
        PrimitiveType primitiveType = type.asPrimitiveType();
        LogicalTypeAnnotation logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
                return new IntDictionaryAwareDecimalColumnReader((DataType)decimalType, decimalLogicalTypeAnnotation.getPrecision(), decimalLogicalTypeAnnotation.getScale(), n);
            }
            return new IntDictionaryAwareDecimalColumnReader((DataType)decimalType, 10, 0, n);
        }
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
                return new LongDictionaryAwareDecimalColumnReader((DataType)decimalType, decimalLogicalTypeAnnotation.getPrecision(), decimalLogicalTypeAnnotation.getScale(), n);
            }
            return new LongDictionaryAwareDecimalColumnReader((DataType)decimalType, 20, 0, n);
        }
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY || primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY) {
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
                return new BinaryDictionaryAwareDecimalColumnReader((DataType)decimalType, decimalLogicalTypeAnnotation.getPrecision(), decimalLogicalTypeAnnotation.getScale(), n);
            }
            throw new RuntimeException(String.format("Unable to create Parquet converter for DecimalType whose parquet type is %s without decimal metadata.", type));
        }
        throw new RuntimeException(String.format("Unable to create Parquet converter for DecimalType whose Parquet type is %s. Parquet DECIMAL type can only be backed by INT32, INT64, FIXED_LEN_BYTE_ARRAY, or BINARY", type));
    }

    public static class BinaryDictionaryAwareDecimalColumnReader
    extends BaseDecimalColumnReader {
        BinaryDictionaryAwareDecimalColumnReader(DataType dataType, int n, int n2, int n3) {
            super(dataType, n, n2, n3);
        }

        public void setDictionary(Dictionary dictionary) {
            this.expandedDictionary = new BigDecimal[dictionary.getMaxId() + 1];
            for (int i = 0; i < dictionary.getMaxId() + 1; ++i) {
                this.expandedDictionary[i] = this.decimalFromBinary(dictionary.decodeToBinary(i));
            }
        }

        public void addBinary(Binary binary) {
            this.addDecimal(this.decimalFromBinary(binary));
        }
    }

    public static class LongDictionaryAwareDecimalColumnReader
    extends BaseDecimalColumnReader {
        LongDictionaryAwareDecimalColumnReader(DataType dataType, int n, int n2, int n3) {
            super(dataType, n, n2, n3);
        }

        public void setDictionary(Dictionary dictionary) {
            this.expandedDictionary = new BigDecimal[dictionary.getMaxId() + 1];
            for (int i = 0; i < dictionary.getMaxId() + 1; ++i) {
                this.expandedDictionary[i] = this.decimalFromLong(dictionary.decodeToLong(i));
            }
        }

        public void addLong(long l) {
            this.addDecimal(this.decimalFromLong(l));
        }
    }

    public static class IntDictionaryAwareDecimalColumnReader
    extends BaseDecimalColumnReader {
        IntDictionaryAwareDecimalColumnReader(DataType dataType, int n, int n2, int n3) {
            super(dataType, n, n2, n3);
        }

        public void setDictionary(Dictionary dictionary) {
            this.expandedDictionary = new BigDecimal[dictionary.getMaxId() + 1];
            for (int i = 0; i < dictionary.getMaxId() + 1; ++i) {
                this.expandedDictionary[i] = this.decimalFromLong(dictionary.decodeToInt(i));
            }
        }

        public void addInt(int n) {
            this.addDecimal(this.decimalFromLong(n));
        }
    }

    public static abstract class BaseDecimalColumnReader
    extends ParquetColumnReaders.BasePrimitiveColumnReader {
        private BigDecimal[] values;
        private final DecimalType decimalType;
        private final int scale;
        protected BigDecimal[] expandedDictionary;

        BaseDecimalColumnReader(DataType dataType, int n, int n2, int n3) {
            super(n3);
            DecimalType decimalType = (DecimalType)dataType;
            int n4 = decimalType.getScale() - n2;
            int n5 = decimalType.getPrecision() - n;
            Preconditions.checkArgument((n4 >= 0 && n5 >= n4 ? 1 : 0) != 0, (String)"Found Delta type %s but Parquet type has precision=%s and scale=%s", (Object[])new Object[]{decimalType, n, n2});
            this.scale = n2;
            this.decimalType = decimalType;
            this.values = new BigDecimal[n3];
        }

        public boolean hasDictionarySupport() {
            return true;
        }

        protected void addDecimal(BigDecimal bigDecimal) {
            this.resizeIfNeeded();
            this.nullability[this.currentRowIndex] = false;
            if (this.decimalType.getScale() != this.scale) {
                bigDecimal = bigDecimal.setScale(this.decimalType.getScale(), RoundingMode.UNNECESSARY);
            }
            this.values[this.currentRowIndex] = bigDecimal;
        }

        public void addValueFromDictionary(int n) {
            this.addDecimal(this.expandedDictionary[n]);
        }

        @Override
        public ColumnVector getDataColumnVector(int n) {
            DefaultDecimalVector defaultDecimalVector = new DefaultDecimalVector((DataType)this.decimalType, n, this.values);
            this.nullability = ParquetColumnReaders.initNullabilityVector(this.nullability.length);
            this.values = new BigDecimal[this.values.length];
            this.currentRowIndex = 0;
            return defaultDecimalVector;
        }

        @Override
        public void resizeIfNeeded() {
            if (this.values.length == this.currentRowIndex) {
                int n = this.values.length * 2;
                this.values = Arrays.copyOf(this.values, n);
                this.nullability = Arrays.copyOf(this.nullability, n);
                ParquetColumnReaders.setNullabilityToTrue(this.nullability, n / 2, n);
            }
        }

        protected BigDecimal decimalFromLong(long l) {
            return BigDecimal.valueOf(l, this.scale);
        }

        protected BigDecimal decimalFromBinary(Binary binary) {
            return new BigDecimal(new BigInteger(binary.getBytes()), this.scale);
        }
    }
}

