/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.semiimpl;

import com.dataiku.dip.datalayer.CellData;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SemiKnownRow
implements Row,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> unknownMap;
    private boolean deleted;
    private Row.RowContext recordContext;

    public Map<String, String> getUndeclared() {
        if (this.unknownMap == null) {
            this.unknownMap = new HashMap<String, String>();
        }
        return this.unknownMap;
    }

    public Row.RowContext getRowContext() {
        if (this.recordContext == null) {
            this.recordContext = new Row.RowContext();
        }
        return this.recordContext;
    }

    public void put(Column key, String value) {
        if (this.unknownMap == null) {
            this.unknownMap = new HashMap<String, String>();
        }
        if (value == null || value.length() == 0) {
            this.delete(key);
        } else {
            this.unknownMap.put(key.getName(), value);
        }
    }

    public void put(Column key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void put(Column key, long value) {
        this.put(key, String.valueOf(value));
    }

    public void put(Column key, double value) {
        this.put(key, String.valueOf(value));
    }

    public void put(Column key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public Row with(Column key, String value) {
        this.put(key, value);
        return this;
    }

    public Row with(Column key, int value) {
        this.put(key, String.valueOf(value));
        return this;
    }

    public Row with(Column key, long value) {
        this.put(key, String.valueOf(value));
        return this;
    }

    public Row with(Column key, double value) {
        this.put(key, String.valueOf(value));
        return this;
    }

    public Row with(Column key, boolean value) {
        return null;
    }

    public void delete(Column key) {
        if (this.unknownMap == null) {
            this.unknownMap = new HashMap<String, String>();
        }
        this.unknownMap.remove(key.getName());
    }

    public void delete() {
        this.deleted = true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Row with(ColumnFactory cf, String key, String value) {
        this.put(cf.column(key), value);
        return this;
    }

    public String get(Column cd) {
        if (this.unknownMap == null) {
            return null;
        }
        return this.unknownMap.get(cd.getName());
    }

    public String get(Column cd, String defaultValue) {
        if (this.unknownMap == null) {
            return null;
        }
        if (!this.unknownMap.containsKey(cd.getName())) {
            return defaultValue;
        }
        return this.unknownMap.get(cd.getName());
    }

    public boolean empty(Column cd) {
        if (this.unknownMap == null) {
            return true;
        }
        String v = this.unknownMap.get(cd.getName());
        return v == null || v.length() == 0;
    }

    public void get(Column cd, CellData buf) {
        String data = this.get(cd);
        if (data == null || data.length() == 0) {
            buf.reset();
        } else {
            buf.set(data.toCharArray(), 0, data.length());
        }
    }

    public double getAsDoubleOrNaN(Column cd) {
        String v = this.get(cd);
        if (StringUtils.isBlank((String)v)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public String toString() {
        return "<SKR: unknown=" + this.unknownMap.toString() + " del=" + this.deleted + ">";
    }
}

