/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedActivityRunner;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeHelper;
import com.dataiku.dip.remoterun.RemoteRunLocalFilesHelper;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;

public final class package$ {
    public static package$ MODULE$;
    private Map<String, String> envVars;
    private final Logger logger;

    static {
        new package$();
    }

    private Map<String, String> envVars() {
        return this.envVars;
    }

    private void envVars_$eq(Map<String, String> x$1) {
        this.envVars = x$1;
    }

    public boolean isDatabricks() {
        boolean bl;
        try {
            Class.forName("com.databricks.backend.daemon.driver.DriverWrapper");
            this.logger().info((Object)"May be Databricks, initializing remote env");
            RemoteRunEnvHelper.getEnvDef();
            bl = true;
        }
        catch (Throwable t) {
            bl = false;
        }
        return bl;
    }

    public boolean isYarnCluster() {
        return RemoteRunEnvHelper.getEnvDef().runsRemotely;
    }

    public String getDkuJobId() {
        return RemoteRunEnvHelper.getEnvDef().jobId;
    }

    public Option<AbstractCodeBasedActivityRunner.FlowSpec> getFlowSpec() {
        if (RemoteRunEnvHelper.getEnvDef().flowSpec != null) {
            return new Some((Object)RemoteRunEnvHelper.getEnvDef().flowSpec);
        }
        return None$.MODULE$;
    }

    public java.util.Map<String, String> getFlowVariablesAsJava() {
        if (RemoteRunEnvHelper.getEnvDef().flowVariables != null) {
            return RemoteRunEnvHelper.getEnvDef().flowVariables;
        }
        return new HashMap<String, String>();
    }

    public Map<String, String> getFlowVariables() {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.getFlowVariablesAsJava()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public java.util.Map<String, Object> getCustomVariablesAsJava() {
        if (RemoteRunEnvHelper.getEnvDef().customVariables != null) {
            return RemoteRunEnvHelper.getEnvDef().customVariables;
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getCustomVariables() {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.getCustomVariablesAsJava()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public java.util.Map<String, String> getEnvVarsAsJava() {
        return RemoteRunEnvHelper.getEnvDef().env;
    }

    public Map<String, String> getEnvVars() {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.getEnvVarsAsJava()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<String> get(String key) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.getEnvVarsAsJava()).asScala()).get((Object)key);
    }

    public String getOrElse(String key, String defaultValue) {
        return (String)this.get(key).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultValue);
    }

    public String getTicketFromEnv() {
        String ticket = this.getOrElse("DKU_API_TICKET", null);
        this.logger().info((Object)new StringBuilder(20).append("Got ticket from env ").append(ticket).toString());
        if (ticket == null) {
            throw new IllegalArgumentException("No ticket in environment, cannot continue");
        }
        return ticket;
    }

    public String getProjectFromEnv() {
        return this.getOrElse("DKU_CURRENT_PROJECT_KEY", "DEFAULT");
    }

    public SparkJobExecEnv getJobExecEnv() {
        return RemoteRunEnvHelper.getEnvDef().jobExecEnv;
    }

    public <T> T getFromResourceOrFile(String name, ClassTag<T> ct) {
        InputStream is = RemoteRunLocalFilesHelper.openResourceOrFile((String)name);
        if (is != null) {
            Object ret = JSON.parse((InputStream)is, (Class)ct.runtimeClass());
            is.close();
            return (T)ret;
        }
        return null;
    }

    public File getLocalInputFile(String path) {
        return RemoteRunLocalFilesHelper.getInputFileInBaseFolderOrCwd((String)path);
    }

    public File getLocalRunFile(String path) {
        return RemoteRunLocalFilesHelper.getRunFile((String)path);
    }

    public String readResourceOrFileAsString(String name) {
        return RemoteRunLocalFilesHelper.readResourceOrFileAsString((String)name);
    }

    public boolean exitWhenDone(SparkContext sc) {
        return !this.isDatabricks() && (!RemoteRunEnvHelper.getEnvDef().runsRemotely || RemoteRunEnvHelper.getEnvDef().callContextStop) && !new StringOps(Predef$.MODULE$.augmentString(sc.getConf().get("spark.dku.keepAlive", "false"))).toBoolean();
    }

    public void exitWhenDoneIfNeeded(SparkContext sc) {
        if (this.exitWhenDone(sc)) {
            this.logger().info((Object)"Shutting down Spark context");
            sc.stop();
            System.exit(0);
            return;
        }
    }

    public void storeSerializedError(SerializedError serializedError) {
        try {
            com.dataiku.dip.utils.package$.MODULE$.initializeApplication(com.dataiku.dip.utils.package$.MODULE$.initializeApplication$default$1(), com.dataiku.dip.utils.package$.MODULE$.initializeApplication$default$2());
            RemoteRunFileExchangeHelper.storeJsonOutput((String)"error.json", (Object)serializedError);
        }
        catch (Throwable t) {
            this.logger().error((Object)"failed to write error file", t);
        }
    }

    public void storeJsonResult(String path, Object o) {
        RemoteRunFileExchangeHelper.storeJsonOutput((String)path, (Object)o);
    }

    public void storeError(Throwable t) {
        this.logger().error((Object)"job failed", t);
        SerializedError serializedError = new SerializedError(t, true);
        this.storeSerializedError(serializedError);
    }

    public void storeExternalError(String e) {
        this.logger().error((Object)new StringBuilder(11).append("job failed ").append(e).toString());
        SerializedError serializedError = (SerializedError)JSON.parse((String)e, SerializedError.class);
        this.storeSerializedError(serializedError);
    }

    private Logger logger() {
        return this.logger;
    }

    private package$() {
        MODULE$ = this;
        this.envVars = null;
        this.logger = Logger.getLogger((String)"dku.spark.env");
    }
}

